/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;

public class CreateVirtualTable
implements Stmt {
    public final boolean ifNotExists;
    public final QualifiedName tblName;
    public final String moduleName;
    public String args;

    public CreateVirtualTable(boolean ifNotExists, QualifiedName tblName, String moduleName) {
        this.ifNotExists = ifNotExists;
        this.tblName = Objects.requireNonNull(tblName);
        this.moduleName = Objects.requireNonNull(moduleName);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("CREATE VIRTUAL TABLE ");
        if (this.ifNotExists) {
            a.append("IF NOT EXISTS ");
        }
        this.tblName.toSql(a);
        a.append(" USING ");
        ToSql.doubleQuote(a, this.moduleName);
        a.append('(');
        if (this.args != null && !this.args.isEmpty()) {
            a.append(this.args);
        }
        a.append(')');
    }
}

