/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.IndexedColumn;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.OnDeleteRefArg;
import org.sqlite.parser.ast.OnUpdateRefArg;
import org.sqlite.parser.ast.RefAct;
import org.sqlite.parser.ast.RefArg;
import org.sqlite.parser.ast.ToSql;

public class ForeignKeyClause
implements ToSql {
    public final String tblName;
    public final List<IndexedColumn> columns;
    public final List<RefArg> args;

    public ForeignKeyClause(String tblName, List<IndexedColumn> columns, List<RefArg> args) {
        this.tblName = Objects.requireNonNull(tblName);
        this.columns = columns;
        this.args = args;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        ToSql.doubleQuote(a, this.tblName);
        if (ToSql.isNotEmpty(this.columns)) {
            a.append('(');
            ToSql.comma(a, this.columns);
            a.append(')');
        }
        if (ToSql.isNotEmpty(this.args)) {
            for (RefArg arg : this.args) {
                a.append(' ');
                arg.toSql(a);
            }
        }
    }

    public LiteralExpr getUpdateRule() {
        if (ToSql.isNotEmpty(this.args)) {
            for (RefArg arg : this.args) {
                if (!(arg instanceof OnUpdateRefArg)) continue;
                RefAct refAct = ((OnUpdateRefArg)arg).refAct;
                return LiteralExpr.integer(refAct.getRule());
            }
        }
        return LiteralExpr.integer(3);
    }

    public LiteralExpr getDeleteRule() {
        if (ToSql.isNotEmpty(this.args)) {
            for (RefArg arg : this.args) {
                if (!(arg instanceof OnDeleteRefArg)) continue;
                RefAct refAct = ((OnDeleteRefArg)arg).refAct;
                return LiteralExpr.integer(refAct.getRule());
            }
        }
        return LiteralExpr.integer(3);
    }
}

