/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Distinctness;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.Window;

public class FunctionCallExpr
implements Expr {
    public final String name;
    public final Distinctness distinctness;
    public final List<Expr> args;
    public final Window overClause;

    public static FunctionCallExpr lower(Expr expr) {
        return new FunctionCallExpr("lower", null, Collections.singletonList(expr), null);
    }

    public static FunctionCallExpr from(String name, Expr ... args) {
        return new FunctionCallExpr(name, null, Arrays.asList(args), null);
    }

    public FunctionCallExpr(String name, Distinctness distinctness, List<Expr> args, Window overClause) {
        this.name = Objects.requireNonNull(name);
        this.distinctness = distinctness;
        this.args = args;
        this.overClause = overClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        ToSql.doubleQuote(a, this.name);
        a.append('(');
        if (this.distinctness != null) {
            this.distinctness.toSql(a);
            a.append(' ');
        }
        if (ToSql.isNotEmpty(this.args)) {
            ToSql.comma(a, this.args);
        }
        a.append(')');
        if (this.overClause != null) {
            a.append(' ');
            this.overClause.toSql(a);
        }
    }
}

