/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ToSql;

public class InListExpr
implements Expr {
    public final Expr lhs;
    public final boolean not;
    public final List<Expr> rhs;

    public InListExpr(Expr lhs, boolean not, List<Expr> rhs) {
        this.lhs = Objects.requireNonNull(lhs);
        this.not = not;
        this.rhs = rhs;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.lhs.toSql(a);
        if (this.not) {
            a.append(" NOT");
        }
        a.append(" IN (");
        if (ToSql.isNotEmpty(this.rhs)) {
            ToSql.comma(a, this.rhs);
        }
        a.append(")");
    }
}

