/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.Select;

public class InSelectExpr
implements Expr {
    public final Expr lhs;
    public final boolean not;
    public final Select rhs;

    public InSelectExpr(Expr lhs, boolean not, Select rhs) {
        this.lhs = Objects.requireNonNull(lhs);
        this.not = not;
        this.rhs = Objects.requireNonNull(rhs);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.lhs.toSql(a);
        if (this.not) {
            a.append(" NOT");
        }
        a.append(" IN (");
        this.rhs.toSql(a);
        a.append(")");
    }
}

