/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.Select;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.Upsert;
import org.sqlite.parser.ast.With;

public class Insert
implements Stmt {
    public final With with;
    public final ResolveType orConflict;
    public final QualifiedName tblName;
    public final List<String> columns;
    public final Select select;
    public final Upsert upsert;

    public Insert(With with, ResolveType orConflict, QualifiedName tblName, List<String> columns, Select select, Upsert upsert) {
        this.with = with;
        this.orConflict = orConflict;
        this.tblName = Objects.requireNonNull(tblName);
        this.columns = columns;
        this.select = select;
        this.upsert = upsert;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.with != null) {
            this.with.toSql(a);
            a.append(' ');
        }
        if (ResolveType.Replace == this.orConflict) {
            a.append("REPLACE");
        } else {
            a.append("INSERT");
            if (this.orConflict != null) {
                a.append(" OR ");
                this.orConflict.toSql(a);
            }
        }
        a.append(" INTO ");
        this.tblName.toSql(a);
        if (ToSql.isNotEmpty(this.columns)) {
            a.append(" (");
            ToSql.commaNames(a, this.columns);
            a.append(')');
        }
        a.append(' ');
        if (this.select != null) {
            this.select.toSql(a);
            if (this.upsert != null) {
                this.upsert.toSql(a);
            }
        } else {
            a.append("DEFAULT VALUES");
        }
    }
}

