/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.TokenType;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.NullOperator;

public class IsNullExpr
implements Expr {
    public final Expr expr;
    public final NullOperator op;

    public static IsNullExpr from(Expr expr, short tt) {
        if (50 == tt) {
            return new IsNullExpr(expr, NullOperator.IsNull);
        }
        if (51 == tt) {
            return new IsNullExpr(expr, NullOperator.NotNull);
        }
        throw new IllegalArgumentException(String.format("Unsupported null expression: %s", TokenType.toString(tt)));
    }

    public IsNullExpr(Expr expr, NullOperator op) {
        this.expr = Objects.requireNonNull(expr);
        this.op = Objects.requireNonNull(op);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.expr.toSql(a);
        a.append(' ');
        this.op.toSql(a);
    }
}

