/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import org.sqlite.parser.Token;
import org.sqlite.parser.ast.JoinType;
import org.sqlite.parser.ast.ToSql;

public class JoinOperator
implements ToSql {
    public final boolean comma;
    public final boolean natural;
    public final JoinType joinType;

    public static JoinOperator comma() {
        return new JoinOperator(true, false, null);
    }

    public static JoinOperator typedJoin(boolean natural, JoinType joinType) {
        return new JoinOperator(false, natural, joinType);
    }

    private JoinOperator(boolean comma, boolean natural, JoinType joinType) {
        this.comma = comma;
        this.natural = natural;
        this.joinType = joinType;
    }

    public static JoinOperator from(Token a, Token b, Token c) {
        if (26 == a.tokenType()) {
            return JoinOperator.comma();
        }
        if (b == null && c == null) {
            if (132 == a.tokenType()) {
                return JoinOperator.typedJoin(false, null);
            }
            if ("NATURAL".equalsIgnoreCase(a.text())) {
                return JoinOperator.typedJoin(true, null);
            }
            return JoinOperator.typedJoin(false, JoinType.from(a, null));
        }
        if ("NATURAL".equalsIgnoreCase(a.text())) {
            return JoinOperator.typedJoin(true, JoinType.from(b, c));
        }
        assert (c == null);
        return JoinOperator.typedJoin(false, JoinType.from(a, b));
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.comma) {
            a.append(',');
        } else {
            if (this.natural) {
                a.append(" NATURAL");
            }
            if (this.joinType != null) {
                a.append(' ');
                this.joinType.toSql(a);
            }
            a.append(" JOIN");
        }
    }
}

