/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import org.sqlite.parser.Token;
import org.sqlite.parser.ast.ToSql;

public enum LikeOperator implements ToSql
{
    Glob,
    Like,
    Match,
    Regexp;


    public static LikeOperator from(Token token) {
        if (46 == token.tokenType()) {
            return Match;
        }
        if (47 != token.tokenType()) {
            throw new IllegalArgumentException(String.format("Unsupported Like operator: %s", token));
        }
        if ("GLOB".equalsIgnoreCase(token.text())) {
            return Glob;
        }
        if ("LIKE".equalsIgnoreCase(token.text())) {
            return Like;
        }
        if ("REGEXP".equalsIgnoreCase(token.text())) {
            return Regexp;
        }
        throw new IllegalArgumentException(String.format("Unsupported Like operator: %s", token));
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (Glob == this) {
            a.append("GLOB");
        } else if (Like == this) {
            a.append("LIKE");
        } else if (Match == this) {
            a.append("MATCH");
        } else if (Regexp == this) {
            a.append("REGEXP");
        }
    }
}

