/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.Token;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.LiteralType;
import org.sqlite.parser.ast.ToSql;

public class LiteralExpr
implements Expr {
    public static final LiteralExpr NULL = new LiteralExpr("NULL", LiteralType.Keyword);
    public static final LiteralExpr EMPTY_STRING = new LiteralExpr("", LiteralType.String);
    public final String value;
    public final LiteralType type;

    public static LiteralExpr from(Token t) {
        LiteralType type = LiteralType.from(t.tokenType());
        return new LiteralExpr(t.text(), type);
    }

    public static LiteralExpr integer(int value) {
        return new LiteralExpr(String.valueOf(value), LiteralType.Integer);
    }

    public static LiteralExpr string(String value) {
        if (value == null) {
            return NULL;
        }
        if (value.isEmpty()) {
            return EMPTY_STRING;
        }
        return new LiteralExpr(value, LiteralType.String);
    }

    public LiteralExpr(String value, LiteralType type) {
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (LiteralType.String == this.type) {
            ToSql.singleQuote(a, this.value);
        } else if (LiteralType.Float == this.type) {
            a.append(this.value);
        } else if (LiteralType.Integer == this.type) {
            a.append(this.value);
        } else if (LiteralType.Keyword == this.type) {
            a.append(this.value);
        } else if (LiteralType.Blob == this.type) {
            a.append('X');
            ToSql.singleQuote(a, this.value);
        }
    }
}

