/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import org.sqlite.parser.ast.ColumnConstraint;
import org.sqlite.parser.ast.ResolveType;

public class NotNullColumnConstraint
extends ColumnConstraint {
    public final boolean nullable;
    public final ResolveType conflictClause;

    public NotNullColumnConstraint(String name, boolean nullable, ResolveType conflictClause) {
        super(name);
        this.nullable = nullable;
        this.conflictClause = conflictClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.constraintName(a);
        if (!this.nullable) {
            a.append("NOT ");
        }
        a.append("NULL");
        if (this.conflictClause != null) {
            a.append(" ON CONFLICT ");
            this.conflictClause.toSql(a);
        }
    }

    public int getNullable() {
        if (this.nullable) {
            return 1;
        }
        return 0;
    }
}

