/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import org.sqlite.parser.ast.Distinctness;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.FromClause;
import org.sqlite.parser.ast.GroupBy;
import org.sqlite.parser.ast.ResultColumn;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.Window;

public class OneSelect
implements ToSql {
    public final Distinctness distinctness;
    public final List<ResultColumn> columns;
    public final FromClause from;
    public final Expr whereClause;
    public final GroupBy groupBy;
    public final List<Window> windowClause;
    public final List<List<Expr>> values;

    public OneSelect(Distinctness distinctness, List<ResultColumn> columns, FromClause from, Expr whereClause, GroupBy groupBy, List<Window> windowClause) {
        this.distinctness = distinctness;
        this.columns = ToSql.requireNotEmpty(columns);
        this.from = from;
        this.whereClause = whereClause;
        this.groupBy = groupBy;
        this.windowClause = windowClause;
        this.values = null;
    }

    public OneSelect(List<List<Expr>> values) {
        this.distinctness = null;
        this.columns = null;
        this.from = null;
        this.whereClause = null;
        this.groupBy = null;
        this.windowClause = null;
        this.values = ToSql.requireNotEmpty(values);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (i == 0) {
                    a.append("VALUES (");
                } else {
                    a.append(", (");
                }
                ToSql.comma(a, this.values.get(i));
                a.append(")");
            }
            return;
        }
        a.append("SELECT");
        if (this.distinctness != null) {
            a.append(' ');
            this.distinctness.toSql(a);
        }
        a.append(' ');
        ToSql.comma(a, this.columns);
        if (this.from != null) {
            a.append(" FROM ");
            this.from.toSql(a);
        }
        if (this.whereClause != null) {
            a.append(" WHERE ");
            this.whereClause.toSql(a);
        }
        if (this.groupBy != null) {
            a.append(' ');
            this.groupBy.toSql(a);
        }
        if (this.windowClause != null) {
            a.append(" WINDOW ");
            ToSql.comma(a, this.windowClause);
        }
    }
}

