/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.Token;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.Stmt;

public class Pragma
implements Stmt {
    public final QualifiedName name;
    public final Expr value;

    public static Pragma from(Token x, String y, Expr value) {
        return new Pragma(QualifiedName.from(x, y), value);
    }

    public Pragma(QualifiedName name, Expr value) {
        this.name = Objects.requireNonNull(name);
        this.value = value;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("PRAGMA ");
        this.name.toSql(a);
        if (this.value != null) {
            a.append('(');
            this.value.toSql(a);
            a.append(')');
        }
    }
}

