/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.Token;
import org.sqlite.parser.ast.ToSql;

public class QualifiedName
implements ToSql {
    public final String dbName;
    public final String name;
    public String alias;

    public static QualifiedName from(Token xxx, Token yyy, Token alias) {
        QualifiedName qn = xxx == null ? new QualifiedName(null, yyy.text()) : new QualifiedName(xxx.text(), yyy.text());
        if (alias != null) {
            qn.alias = alias.text();
        }
        return qn;
    }

    public static QualifiedName from(Token xxx, String yyy) {
        if (yyy == null) {
            return new QualifiedName(null, xxx.text());
        }
        return new QualifiedName(xxx.text(), yyy);
    }

    public QualifiedName(String dbName, String name) {
        this.dbName = dbName;
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.dbName != null) {
            ToSql.doubleQuote(a, this.dbName);
            a.append('.');
        }
        ToSql.doubleQuote(a, this.name);
        if (this.alias != null) {
            a.append(" AS ");
            ToSql.doubleQuote(a, this.alias);
        }
    }
}

