/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.As;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ToSql;

public class ResultColumn
implements ToSql {
    public final Expr expr;
    public final As as;
    public final String tblName;

    public static ResultColumn expr(Expr expr, As as) {
        return new ResultColumn(Objects.requireNonNull(expr), as, null);
    }

    public static ResultColumn star() {
        return new ResultColumn(null, null, null);
    }

    public static ResultColumn tableStar(String tblName) {
        return new ResultColumn(null, null, Objects.requireNonNull(tblName));
    }

    private ResultColumn(Expr expr, As as, String tblName) {
        this.expr = expr;
        this.as = as;
        this.tblName = tblName;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.expr != null) {
            this.expr.toSql(a);
            if (this.as != null) {
                a.append(' ');
                this.as.toSql(a);
            }
        } else if (this.tblName == null) {
            a.append('*');
        } else {
            ToSql.doubleQuote(a, this.tblName);
            a.append(".*");
        }
    }
}

