/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ToSql;

public class Set
implements ToSql {
    public final List<String> colNames;
    public final Expr expr;

    public Set(String colName, Expr expr) {
        this.colNames = Collections.singletonList(Objects.requireNonNull(colName));
        this.expr = Objects.requireNonNull(expr);
    }

    public Set(List<String> colNames, Expr expr) {
        this.colNames = ToSql.requireNotEmpty(colNames);
        this.expr = Objects.requireNonNull(expr);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.colNames.size() == 1) {
            ToSql.doubleQuote(a, this.colNames.get(0));
        } else {
            a.append('(');
            ToSql.commaNames(a, this.colNames);
            a.append(')');
        }
        a.append(" = ");
        this.expr.toSql(a);
    }
}

