/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.sqlite.parser.Identifier;
import org.sqlite.parser.Keyword;

public interface ToSql {
    public void toSql(Appendable var1) throws IOException;

    default public String toSql() {
        StringBuilder builder = new StringBuilder();
        try {
            this.toSql(builder);
            return builder.toString();
        }
        catch (IOException e) {
            throw new AssertionError("No IOException expected with StringBuilder", e);
        }
    }

    public static void doubleQuote(Appendable a, String name) throws IOException {
        int i;
        if (name.isEmpty()) {
            a.append("\"\"");
            return;
        }
        boolean isIdentifier = true;
        for (i = 0; i < name.length(); ++i) {
            isIdentifier = i == 0 ? Identifier.isIdentifierStart(name.charAt(i)) : isIdentifier && Identifier.isIdentifierContinue(name.charAt(i));
        }
        if (isIdentifier) {
            if (Keyword.isKeyword(name)) {
                a.append('`');
                a.append(name);
                a.append('`');
                return;
            }
            a.append(name);
            return;
        }
        a.append('\"');
        for (i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\"') {
                a.append(c);
            }
            a.append(c);
        }
        a.append('\"');
    }

    public static void singleQuote(Appendable a, String value) throws IOException {
        a.append('\'');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                a.append(c);
            }
            a.append(c);
        }
        a.append('\'');
    }

    public static void comma(Appendable a, List<? extends ToSql> items) throws IOException {
        for (int i = 0; i < items.size(); ++i) {
            if (i != 0) {
                a.append(", ");
            }
            items.get(i).toSql(a);
        }
    }

    public static void commaNames(Appendable a, List<String> names) throws IOException {
        for (int i = 0; i < names.size(); ++i) {
            if (i != 0) {
                a.append(", ");
            }
            ToSql.doubleQuote(a, names.get(i));
        }
    }

    public static <T> List<T> requireNotEmpty(List<T> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        return list;
    }

    public static <T> List<T> nullToEmpty(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static <T> boolean isNotEmpty(List<T> list) {
        return list != null && !list.isEmpty();
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }
}

