/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import org.sqlite.parser.TokenType;
import org.sqlite.parser.ast.ToSql;

public enum TransactionType implements ToSql
{
    Deferred,
    Immediate,
    Exclusive;


    public static TransactionType from(short tt) {
        if (7 == tt) {
            return Deferred;
        }
        if (8 == tt) {
            return Immediate;
        }
        if (9 == tt) {
            return Exclusive;
        }
        throw new IllegalArgumentException(String.format("Unsupported Transaction type: %s", TokenType.toString(tt)));
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (Deferred == this) {
            a.append("DEFERRED");
        } else if (Immediate == this) {
            a.append("IMMEDIATE");
        } else if (Exclusive == this) {
            a.append("EXCLUSIVE");
        }
    }
}

