/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.ToSql;

public class TypeSize
implements ToSql {
    public final Expr size1;
    public final Expr size2;

    public static TypeSize maxSize(Expr max) {
        return new TypeSize(Objects.requireNonNull(max), null);
    }

    public static TypeSize couple(Expr size1, Expr size2) {
        return new TypeSize(Objects.requireNonNull(size1), Objects.requireNonNull(size2));
    }

    private TypeSize(Expr size1, Expr size2) {
        this.size1 = size1;
        this.size2 = size2;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.size1.toSql(a);
        if (this.size2 != null) {
            a.append(", ");
            this.size2.toSql(a);
        }
    }

    public Expr getSize() {
        return this.size1;
    }

    public Expr getDecimalDigits() {
        if (this.size2 == null) {
            return LiteralExpr.NULL;
        }
        return this.size2;
    }
}

