/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.Set;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.TriggerCmd;

public class UpdateTriggerCmd
implements TriggerCmd {
    public final ResolveType orConflict;
    public final String tblName;
    public final List<Set> sets;
    public final Expr whereClause;

    public UpdateTriggerCmd(ResolveType orConflict, String tblName, List<Set> sets, Expr whereClause) {
        this.orConflict = orConflict;
        this.tblName = Objects.requireNonNull(tblName);
        this.sets = ToSql.requireNotEmpty(sets);
        this.whereClause = whereClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("UPDATE ");
        if (this.orConflict != null) {
            a.append("OR ");
            this.orConflict.toSql(a);
            a.append(' ');
        }
        ToSql.doubleQuote(a, this.tblName);
        a.append(" SET ");
        ToSql.comma(a, this.sets);
        if (this.whereClause != null) {
            a.append(" WHERE ");
            this.whereClause.toSql(a);
        }
    }
}

