/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.Set;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.ToSql;

public class Upsert
implements ToSql {
    public final List<SortedColumn> targets;
    public final Expr targetWhere;
    public final List<Set> sets;
    public final Expr where;

    public Upsert(List<SortedColumn> targets, Expr targetWhere, List<Set> sets, Expr where) {
        this.targets = targets;
        this.targetWhere = targetWhere;
        this.sets = sets;
        this.where = where;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append(" ON CONFLICT");
        if (this.targets != null) {
            a.append(" (");
            ToSql.comma(a, this.targets);
            a.append(')');
            if (this.targetWhere != null) {
                a.append(" WHERE ");
                this.targetWhere.toSql(a);
            }
        }
        if (this.sets != null) {
            a.append(" DO UPDATE SET ");
            ToSql.comma(a, this.sets);
            if (this.where != null) {
                a.append(" WHERE ");
                this.where.toSql(a);
            }
        } else {
            a.append(" DO NOTHING");
        }
    }
}

