/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;

public class VariableExpr
implements Expr {
    public final String variable;

    public VariableExpr(String variable) {
        this.variable = Objects.requireNonNull(variable);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.variable.isEmpty()) {
            a.append('?');
            return;
        }
        char c = this.variable.charAt(0);
        if (c == '$' || c == '@' || c == '#' || c == ':') {
            a.append(this.variable);
            return;
        }
        a.append('?');
        a.append(this.variable);
    }
}

