/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.FrameBound;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.ToSql;

public class Window
implements ToSql {
    private short rangeOrRows;
    private FrameBound start;
    private FrameBound end;
    public String name;
    public boolean over;
    public Expr filter;
    public List<Expr> partition;
    public List<SortedColumn> orderBy;

    public Window() {
    }

    public Window(String name, Expr filter) {
        this.name = name;
        this.filter = filter;
        this.over = true;
    }

    public Window(short rangeOrRows, FrameBound frameBound) {
        this(rangeOrRows, frameBound, null);
    }

    public Window(short rangeOrRows, FrameBound start, FrameBound end) {
        this.rangeOrRows = rangeOrRows;
        this.start = start;
        this.end = end;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.over) {
            if (this.filter != null) {
                a.append("FILTER");
                a.append('(');
                a.append("WHERE ");
                this.filter.toSql(a);
                a.append(')');
                a.append(' ');
            }
            a.append("OVER ");
            if (this.name != null) {
                ToSql.doubleQuote(a, this.name);
                return;
            }
        } else {
            ToSql.doubleQuote(a, this.name);
            a.append(" AS ");
        }
        a.append('(');
        if (this.partition != null) {
            a.append("PARTITION BY ");
            ToSql.comma(a, this.partition);
            a.append(' ');
        }
        if (this.orderBy != null) {
            a.append("ORDER BY ");
            ToSql.comma(a, this.orderBy);
            a.append(' ');
        }
        if (this.rangeOrRows != 0) {
            if (this.rangeOrRows == 86) {
                a.append("RANGE ");
            } else if (this.rangeOrRows == 76) {
                a.append("ROWS ");
            }
        }
        if (this.end != null) {
            a.append("BETWEEN ");
        }
        if (this.start != null) {
            this.start.toSql(a);
        }
        if (this.end != null) {
            a.append(" AND ");
            this.end.toSql(a);
        }
        a.append(')');
    }
}

