/*
 * Decompiled with CFR 0.152.
 */
package com.github.hekonsek.rxjava.event;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class Event<T> {
    private final Map<String, Object> headers;
    private final T payload;

    public Event(Map<String, Object> headers, T payload) {
        this.headers = ImmutableMap.copyOf(headers);
        this.payload = payload;
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public T payload() {
        return this.payload;
    }

    public Event<T> withPayload(T payload) {
        return new Event<T>(this.headers, payload);
    }

    public Event<T> withHeader(String key, Object value) {
        ImmutableMap copiedHeaders = ImmutableMap.builder().putAll(this.headers).put((Object)key, value).build();
        return new Event<T>((Map<String, Object>)copiedHeaders, this.payload);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("headers", this.headers).add("payload", this.payload).toString();
    }
}

