/*
 * Decompiled with CFR 0.152.
 */
package com.github.hekonsek.rxjava.event;

import com.github.hekonsek.rxjava.event.Event;
import com.github.hekonsek.rxjava.event.ReplyHandler;
import java.util.Optional;

public final class Headers {
    public static final String ORIGINAL = "rxjava.event.original";
    public static final String ADDRESS = "rxjava.event.address";
    public static final String KEY = "rxjava.event.key";
    public static final String REPLY_CALLBACK = "rxjava.event.reply.callback";

    private Headers() {
    }

    public static <T> Optional<T> original(Event event, Class<T> type) {
        Object originalEvent = event.headers().get(ORIGINAL);
        if (!type.isAssignableFrom(originalEvent.getClass())) {
            throw new IllegalArgumentException("Original event is not of type: " + type.getName());
        }
        return Optional.ofNullable(originalEvent);
    }

    public static <T> T requiredOriginal(Event event, Class<T> type) {
        return Headers.original(event, type).orElseThrow(() -> new IllegalArgumentException("Original event header not found."));
    }

    public static Optional<String> address(Event event) {
        return Optional.ofNullable((String)event.headers().get(ADDRESS));
    }

    public static String requiredAddress(Event event) {
        return Headers.address(event).orElseThrow(() -> new IllegalArgumentException("Address header not found."));
    }

    public static Optional<String> key(Event event) {
        return Optional.ofNullable((String)event.headers().get(KEY));
    }

    public static String requiredKey(Event event) {
        return Headers.key(event).orElseThrow(() -> new IllegalArgumentException("Key header not found."));
    }

    public static Optional<ReplyHandler> replyHandler(Event event) {
        return Optional.ofNullable((ReplyHandler)event.headers().get(REPLY_CALLBACK));
    }

    public static ReplyHandler requiredReplyHandler(Event event) {
        return Headers.replyHandler(event).orElseThrow(() -> new IllegalArgumentException("No reply handler found."));
    }
}

