/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.builder;

import com.alibaba.fastjson.JSONObject;
import com.hecloud.runtime.common.generator.KeyGenerator;
import com.hecloud.runtime.database.builder.BatchSQLBuilder;
import com.hecloud.runtime.database.emuns.ColumnField;
import com.hecloud.runtime.database.emuns.Strategy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class BatchInsertSQLBuilder
implements BatchSQLBuilder {
    private Strategy strategy;
    private List<ColumnField> columnFields;
    private String table;
    private SimpleDateFormat dateFormat;

    public BatchInsertSQLBuilder(Strategy strategy, List<ColumnField> columnFields, String table) {
        this.table = table;
        this.strategy = strategy;
        this.columnFields = columnFields;
    }

    @Override
    public String buildValues(List<?> objects) {
        objects = Optional.ofNullable(objects).orElse(new ArrayList());
        return this.buildInsertValues(objects);
    }

    private String buildInsertValues(List<?> objects) {
        objects = objects.stream().filter(obj -> null != obj && !JSONObject.parseObject((String)JSONObject.toJSONString((Object)obj)).isEmpty()).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        for (Object object : objects) {
            builder.append("(");
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)object));
            for (ColumnField columnField : this.columnFields) {
                if (columnField.isPk() && Strategy.AUTO.equals((Object)this.strategy)) continue;
                if (columnField.isPk() && Strategy.UUID.equals((Object)this.strategy)) {
                    builder.append(this.around(KeyGenerator.uuid())).append(",");
                    continue;
                }
                if (!columnField.isInsert()) continue;
                String field = columnField.getFieldName();
                if (columnField.getFieldType().equals(String.class)) {
                    builder.append(this.around(jsonObject.getString(field))).append(",");
                    continue;
                }
                if (columnField.getFieldType().equals(Date.class)) {
                    this.dateFormat = new SimpleDateFormat(columnField.getFormat());
                    if (null == jsonObject.getDate(field)) {
                        if (columnField.isNullable()) {
                            builder.append("null").append(",");
                            continue;
                        }
                        builder.append(this.around(this.dateFormat.format(new Date())));
                        continue;
                    }
                    builder.append(this.around(this.dateFormat.format(jsonObject.getDate(field)))).append(",");
                    continue;
                }
                builder.append(jsonObject.get((Object)field)).append(",");
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append("),");
        }
        if (builder.length() > 1) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    @Override
    public String buildPrefix() {
        StringBuilder builder = new StringBuilder();
        StringBuilder columns = new StringBuilder();
        this.columnFields = this.columnFields.stream().filter(columnField -> columnField.isInsert()).collect(Collectors.toList());
        for (ColumnField columnFiled : this.columnFields) {
            if (columnFiled.isPk() && this.strategy.equals((Object)Strategy.AUTO)) continue;
            columns.append(columnFiled.getColumnName()).append(",");
        }
        if (columns.length() > 0) {
            columns.deleteCharAt(columns.length() - 1);
            builder.append("INSERT INTO ").append(this.table).append(" (").append((CharSequence)columns).append(") values ");
        }
        return builder.toString();
    }

    private String around(String value) {
        return StringUtils.isEmpty((Object)value) ? "null" : "'" + value + "'";
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public List<ColumnField> getColumnFields() {
        return this.columnFields;
    }

    public String getTable() {
        return this.table;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void setColumnFields(List<ColumnField> columnFields) {
        this.columnFields = columnFields;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchInsertSQLBuilder)) {
            return false;
        }
        BatchInsertSQLBuilder other = (BatchInsertSQLBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        List<ColumnField> this$columnFields = this.getColumnFields();
        List<ColumnField> other$columnFields = other.getColumnFields();
        if (this$columnFields == null ? other$columnFields != null : !((Object)this$columnFields).equals(other$columnFields)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        SimpleDateFormat this$dateFormat = this.getDateFormat();
        SimpleDateFormat other$dateFormat = other.getDateFormat();
        return !(this$dateFormat == null ? other$dateFormat != null : !((Object)this$dateFormat).equals(other$dateFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchInsertSQLBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        List<ColumnField> $columnFields = this.getColumnFields();
        result = result * 59 + ($columnFields == null ? 43 : ((Object)$columnFields).hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        SimpleDateFormat $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : ((Object)$dateFormat).hashCode());
        return result;
    }

    public String toString() {
        return "BatchInsertSQLBuilder(strategy=" + (Object)((Object)this.getStrategy()) + ", columnFields=" + this.getColumnFields() + ", table=" + this.getTable() + ", dateFormat=" + this.getDateFormat() + ")";
    }
}

