/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.builder;

import com.hecloud.runtime.common.collections.Lists;
import com.hecloud.runtime.common.exception.DatabaseException;
import com.hecloud.runtime.database.annotation.Table;
import com.hecloud.runtime.database.cache.SqlCache;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import com.hecloud.runtime.database.emuns.ColumnField;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SQLBuilder {
    private static Logger logger = LoggerFactory.getLogger(SQLBuilder.class);
    SqlCache cache = SqlCache.instance();
    private EntityProcessor processor = new EntityProcessor();

    public String buildSelect(Class<?> clazz) {
        List<ColumnField> columnFieldList = this.processor.loadColumnField(clazz);
        return this.buildSelect(clazz, columnFieldList);
    }

    public String buildSelect(Class<?> clazz, String[] fields) {
        String table = this.processor.loadTableName(clazz);
        if (com.hecloud.runtime.common.collections.Arrays.isEmpty((Object[])fields)) {
            return "SELECT  *  FROM " + table;
        }
        StringBuilder builder = new StringBuilder("SELECT ");
        Optional.ofNullable(fields).ifPresent(FIELDS -> Arrays.stream(FIELDS).filter(f -> StringUtils.isNotBlank((CharSequence)f)).forEach(field -> builder.append((String)field).append(",")));
        builder.deleteCharAt(builder.length() - 1);
        builder.append(table);
        return builder.toString();
    }

    public String buildInsert(Class<?> clazz) {
        List<ColumnField> columnFiledList = this.processor.loadColumnField(clazz);
        return this.buildInsert(clazz, columnFiledList);
    }

    public String buildUpdate(Class<?> clazz) {
        List<ColumnField> columnFields = this.processor.loadColumnField(clazz);
        return this.buildUpdateByPK(clazz, columnFields);
    }

    public String buildUpdateSqlByColumns(Class<?> clazz, String[] fields) throws Exception {
        if (clazz.isAnnotationPresent(Table.class)) {
            List<ColumnField> columnFiledList = this.processor.loadColumnField(clazz);
            String sql = this.assembleUpdateColumn(clazz, columnFiledList, fields);
            StringBuilder builder = new StringBuilder(sql);
            builder.append(" WHERE ");
            columnFiledList.stream().filter(columnField -> columnField.isPk()).forEach(field -> builder.append(field.getColumnName()).append(" =:").append(field.getFieldName()).append(" AND "));
            builder.delete(builder.length() - 4, builder.length());
            return builder.toString();
        }
        logger.error("{} is not a Table Entity!", clazz);
        throw new Exception("\u5f53\u524d\u7c7b\u4e0d\u662f\u6570\u636e\u8868\u7684\u5b9e\u4f53\u7c7b");
    }

    public String buildDelete(Class<?> clazz) throws DatabaseException {
        List<ColumnField> columnFiledList = this.processor.loadColumnField(clazz);
        return this.buildDeleteByPK(clazz, columnFiledList);
    }

    public String buildDeleteByColumns(Class<?> clazz, String[] columns) throws Exception {
        Assert.notEmpty((Object[])columns, (String)"columns must have value!");
        List<ColumnField> columnFiledList = this.processor.loadColumnField(clazz);
        return this.buildDeleteByColumns(clazz, columnFiledList, columns);
    }

    private String buildSelect(Class<?> clazz, List<ColumnField> columnFields) {
        String sql = this.cache.getSelectCache().getCache(clazz.getName());
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            return sql;
        }
        if (Lists.isEmpty(columnFields)) {
            return "SELECT  *  FROM " + this.processor.loadTableName(clazz);
        }
        StringBuilder builder = new StringBuilder();
        columnFields.stream().filter(columnField -> !columnField.isIgnore()).forEach(field -> builder.append(field.getColumnName().toUpperCase()).append(","));
        builder.delete(builder.length() - 1, builder.length());
        String selectColumn = builder.toString();
        return "SELECT " + selectColumn + " FROM " + this.processor.loadTableName(clazz);
    }

    private String buildInsert(Class<?> clazz, List<ColumnField> columnFiledList) {
        String sql = this.cache.getInsertCache().getCache(clazz.getName());
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            return sql;
        }
        String tableName = this.processor.loadTableName(clazz);
        StringBuilder columnBuilder = new StringBuilder();
        StringBuilder valuesBuilder = new StringBuilder();
        columnFiledList.stream().filter(columnField -> columnField.isInsert()).forEach(columnField -> {
            columnBuilder.append(columnField.getColumnName()).append(",");
            valuesBuilder.append(":").append(columnField.getFieldName()).append(",");
        });
        columnBuilder.deleteCharAt(columnBuilder.length() - 1);
        valuesBuilder.deleteCharAt(valuesBuilder.length() - 1);
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(tableName).append("(").append((CharSequence)columnBuilder).append(") values (").append((CharSequence)valuesBuilder).append(")");
        this.cache.getInsertCache().putCache(clazz.getName(), builder.toString());
        return builder.toString();
    }

    private String buildDeleteByPK(Class<?> clazz, List<ColumnField> columnFiledList) throws DatabaseException {
        String cacheSql = this.cache.getDeleteCache().getCache(clazz.getName() + "_pk");
        if (StringUtils.isNotBlank((CharSequence)cacheSql)) {
            return cacheSql;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.basicDelete(clazz));
        boolean hasPk = false;
        for (ColumnField columnFiled : columnFiledList) {
            if (!columnFiled.isPk()) continue;
            builder.append(columnFiled.getColumnName()).append(" =:").append(columnFiled.getFieldName()).append(" ").append(" AND ");
            hasPk = true;
        }
        if (hasPk) {
            builder.delete(builder.length() - 4, builder.length());
            this.cache.getDeleteCache().putCache(clazz.getName() + "_pk", builder.toString());
            return builder.toString();
        }
        throw new DatabaseException("No\u3000Primary Key Found!", new Throwable());
    }

    private String buildUpdateByPK(Class<?> clazz, List<ColumnField> columnFiledList) {
        String cacheSql = this.cache.getUpdateCache().getCache(clazz.getName() + "_pk");
        if (StringUtils.isNotBlank((CharSequence)cacheSql)) {
            return cacheSql;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.appendBaseUpdate(clazz, columnFiledList));
        if (Lists.isEmpty(columnFiledList)) {
            builder.delete(builder.length() - 6, builder.length());
        } else {
            columnFiledList.stream().filter(columnField -> columnField.isPk()).forEach(columnField -> builder.append(columnField.getColumnName()).append(" =:").append(columnField.getFieldName()).append(" AND "));
            builder.delete(builder.length() - 4, builder.length());
        }
        this.cache.getUpdateCache().putCache(clazz.getName() + "_pk", builder.toString());
        return builder.toString();
    }

    private String appendBaseUpdate(Class<?> clazz, List<ColumnField> columnFiledList) {
        String result = this.cache.getUpdateCache().getCache(clazz.getName() + "_columns");
        if (StringUtils.isBlank((CharSequence)result)) {
            StringBuilder builder = new StringBuilder();
            String tableName = this.processor.loadTableName(clazz);
            builder.append("UPDATE ").append(tableName).append(" SET ");
            columnFiledList.stream().filter(columnField -> columnField.isUpdate() && !columnField.isPk()).forEach(columnField -> builder.append(columnField.getColumnName()).append(" =:").append(columnField.getFieldName()).append(","));
            builder.deleteCharAt(builder.length() - 1);
            builder.append(" WHERE ");
            result = builder.toString();
            this.cache.getUpdateCache().putCache(clazz.getName() + "_columns", result);
        }
        return result;
    }

    private String assembleUpdateColumn(Class<?> clazz, List<ColumnField> columnFiledList, String[] fields) {
        String table = this.processor.loadTableName(clazz);
        StringBuilder builder = new StringBuilder("UPDATE ");
        builder.append(table).append(" SET ");
        for (ColumnField columnFiled : columnFiledList) {
            boolean needless;
            boolean bl = needless = columnFiled.isPk() || columnFiled.isIgnore() || !columnFiled.isUpdate();
            if (needless) {
                logger.info("needless column {}", (Object)columnFiled.getFieldName());
                continue;
            }
            needless = com.hecloud.runtime.common.collections.Arrays.absent((Object[])fields, (Object)columnFiled.getFieldName());
            if (needless) {
                logger.info("needless column {}", (Object)columnFiled.getFieldName());
                continue;
            }
            builder.append(columnFiled.getColumnName());
            builder.append(" =:").append(columnFiled.getFieldName()).append(",");
        }
        int bufferLength = builder.length();
        builder.delete(bufferLength - 1, bufferLength);
        return builder.toString();
    }

    private String buildDeleteByColumns(Class<?> clazz, List<ColumnField> columnFiledList, String[] columns) {
        StringBuilder builder = new StringBuilder();
        String basicDelete = this.cache.getDeleteCache().getCache(clazz.getName() + "_columns");
        if (StringUtils.isNotBlank((CharSequence)basicDelete)) {
            builder.append(basicDelete);
        } else {
            builder.append(this.basicDelete(clazz));
        }
        if (Lists.isEmpty(columnFiledList)) {
            builder.delete(builder.length() - 6, builder.length());
        } else {
            block0: for (String column : columns) {
                for (ColumnField columnFiled : columnFiledList) {
                    if (!column.equals(columnFiled.getFieldName())) continue;
                    builder.append(columnFiled.getColumnName()).append(" =:").append(column).append(" AND ");
                    continue block0;
                }
            }
            builder.delete(builder.length() - 4, builder.length());
        }
        return builder.toString();
    }

    private String basicDelete(Class<?> clazz) {
        String basicDelete = this.cache.getDeleteCache().getCache(clazz.getName() + "_columns");
        if (StringUtils.isBlank((CharSequence)basicDelete)) {
            basicDelete = "DELETE FROM  FROM " + this.processor.loadTableName(clazz) + " FROM ";
            this.cache.getDeleteCache().putCache(clazz.getName() + "_columns", basicDelete);
        }
        return basicDelete;
    }
}

