/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.builder;

import com.alibaba.fastjson.JSONObject;
import com.hecloud.runtime.common.query.Sign;
import com.hecloud.runtime.database.builder.InBuilder;
import com.hecloud.runtime.database.builder.UpdateAction;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBuilder {
    private static final Logger log = LoggerFactory.getLogger(UpdateBuilder.class);
    private static EntityProcessor processor = new EntityProcessor();
    private StringBuilder builder;

    public UpdateBuilder update(Class clazz) {
        this.builder = new StringBuilder("UPDATE ");
        this.builder.append(processor.loadTableName(clazz)).append(" ");
        return this;
    }

    public UpdateBuilder set(UpdateAction ... actions) {
        Optional.ofNullable(actions).ifPresent(data -> this.builder.append(" SET ").append(this.buildAction((UpdateAction)data)).append(" "));
        return this;
    }

    public UpdateBuilder set(String column, Object value) {
        Optional.ofNullable(column).ifPresent(f -> Optional.ofNullable(value).ifPresent(d -> this.builder.append(" SET ").append((String)f).append("=").append(this.buildValue(d)).append(",")));
        return this;
    }

    public UpdateBuilder set(String condition) {
        Optional.ofNullable(condition).ifPresent(data -> this.builder.append(" SET ").append((String)data));
        return this;
    }

    public UpdateBuilder equal(Object value) {
        Optional.ofNullable(value).ifPresent(data -> this.builder.append("=").append(this.buildValue(data)).append(","));
        return this;
    }

    public UpdateBuilder where(String condition) {
        if (this.builder.toString().trim().endsWith(",")) {
            this.builder.deleteCharAt(this.builder.length() - 1);
        }
        Optional.ofNullable(condition).ifPresent(data -> this.builder.append(" WHERE ").append((String)data));
        return this;
    }

    public UpdateBuilder where(String column, Object data) {
        Optional.ofNullable(column).ifPresent(f -> Optional.ofNullable(data).ifPresent(d -> this.builder.append(" WHERE ").append(column).append(" ").append(Sign.EQ.getSign()).append(d.toString())));
        return this;
    }

    public UpdateBuilder whereIn(String column, Collection conditions) {
        if (this.builder.toString().trim().endsWith(",")) {
            this.builder.deleteCharAt(this.builder.length() - 1);
        }
        Optional.ofNullable(column).ifPresent(f -> Optional.ofNullable(conditions).ifPresent(d -> this.builder.append(" WHERE ").append((String)f).append(" IN ").append(InBuilder.build(d))));
        return this;
    }

    public UpdateBuilder and(String condition) {
        Optional.ofNullable(condition).ifPresent(data -> this.builder.append(" AND ").append((String)data));
        return this;
    }

    public UpdateBuilder andIn(String column, Collection conditions) {
        Optional.ofNullable(column).ifPresent(f -> Optional.ofNullable(conditions).ifPresent(data -> this.builder.append(" AND ").append(column).append(" IN ").append(InBuilder.build(conditions))));
        return this;
    }

    public UpdateBuilder or(String condition) {
        Optional.ofNullable(condition).ifPresent(data -> this.builder.append(" OR ").append(condition));
        return this;
    }

    public UpdateBuilder orIn(String field, Collection conditions) {
        Optional.ofNullable(field).ifPresent(f -> Optional.ofNullable(conditions).ifPresent(data -> this.builder.append(" OR ").append((String)f).append(" IN ").append(InBuilder.build(data))));
        return this;
    }

    public String sql() {
        return this.builder.toString();
    }

    private String buildAction(UpdateAction ... actions) {
        StringBuilder builder = new StringBuilder();
        Arrays.stream(actions).forEachOrdered(action -> builder.append(" SET ").append(action.getField()).append("=").append(this.buildValue(action.getValue())).append(","));
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    private String buildValue(Object object) {
        if (object instanceof String) {
            return "'" + object.toString() + "'";
        }
        if (object instanceof Date) {
            return "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(object) + "'";
        }
        if (object instanceof Boolean) {
            return ((Boolean)object).toString();
        }
        return JSONObject.toJSONString((Object)object);
    }

    public static UpdateBuilderBuilder builder() {
        return new UpdateBuilderBuilder();
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateBuilder)) {
            return false;
        }
        UpdateBuilder other = (UpdateBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringBuilder this$builder = this.getBuilder();
        StringBuilder other$builder = other.getBuilder();
        return !(this$builder == null ? other$builder != null : !this$builder.equals(other$builder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringBuilder $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateBuilder(builder=" + this.getBuilder() + ")";
    }

    private UpdateBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    public static class UpdateBuilderBuilder {
        private StringBuilder builder;

        UpdateBuilderBuilder() {
        }

        public UpdateBuilderBuilder builder(StringBuilder builder) {
            this.builder = builder;
            return this;
        }

        public UpdateBuilder build() {
            return new UpdateBuilder(this.builder);
        }

        public String toString() {
            return "UpdateBuilder.UpdateBuilderBuilder(builder=" + this.builder + ")";
        }
    }
}

