/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class UpdateCache
extends LinkedHashMap<String, String> {
    private static final long serialVersionUID = 1L;
    private int capacity = 16;

    public UpdateCache(int capacity) {
        super(16, 0.75f, true);
        if (capacity > 0) {
            this.capacity = capacity;
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
        return super.size() > this.capacity;
    }

    public synchronized void putCache(String key, String value) {
        this.put(key, value);
    }

    public synchronized String getCache(String key) {
        String value = (String)this.get(key);
        Optional.ofNullable(value).ifPresent(data -> this.put(key, data));
        return value;
    }
}

