/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.convertor;

import com.hecloud.runtime.common.collections.Lists;
import com.hecloud.runtime.common.exception.DatabaseException;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import com.hecloud.runtime.database.emuns.ColumnField;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;

public class BeanConverter {
    private EntityProcessor metaProcessor;

    public Object mapToBean(Map<String, Object> map, Class<?> pojoClass) throws Throwable {
        Assert.notEmpty(map, (String)"metadata map is null!");
        List<ColumnField> columnFieldList = this.metaProcessor.loadColumnField(pojoClass);
        if (Lists.isEmpty(columnFieldList)) {
            throw new DatabaseException(new Throwable("PojoClass has no fields"));
        }
        Object result = pojoClass.newInstance();
        Set<String> mapKeySet = map.keySet();
        int absentFieldNum = 0;
        for (ColumnField columnFiled : columnFieldList) {
            String columnName = columnFiled.getColumnName();
            if (!mapKeySet.contains(columnName)) {
                ++absentFieldNum;
                continue;
            }
            Object columnValue = map.get(columnName);
            if (null == columnValue) continue;
            String fieldName = columnFiled.getFieldName();
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method method = pojoClass.getMethod(methodName, columnFiled.getFieldType());
            if (columnFiled.getFieldType().equals(Boolean.class)) {
                if (columnValue.toString().equals("0") || !Boolean.valueOf(columnValue.toString()).booleanValue()) {
                    method.invoke(result, false);
                    continue;
                }
                method.invoke(result, true);
                continue;
            }
            if (columnFiled.getFieldType().isEnum()) {
                Class<?> enumClazz = columnFiled.getFieldType();
                Method enumMethod = enumClazz.getMethod("valueOf", String.class);
                if (null == columnValue) continue;
                Object enumObject = enumMethod.invoke(null, columnValue);
                method.invoke(result, enumObject);
                continue;
            }
            method.invoke(result, columnValue);
        }
        if (absentFieldNum == columnFieldList.size()) {
            throw new Exception("All fields of the given class is absent in the map keySet");
        }
        return result;
    }

    public EntityProcessor getMetaProcessor() {
        return this.metaProcessor;
    }

    public void setMetaProcessor(EntityProcessor metaProcessor) {
        this.metaProcessor = metaProcessor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeanConverter)) {
            return false;
        }
        BeanConverter other = (BeanConverter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityProcessor this$metaProcessor = this.getMetaProcessor();
        EntityProcessor other$metaProcessor = other.getMetaProcessor();
        return !(this$metaProcessor == null ? other$metaProcessor != null : !this$metaProcessor.equals(other$metaProcessor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeanConverter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityProcessor $metaProcessor = this.getMetaProcessor();
        result = result * 59 + ($metaProcessor == null ? 43 : $metaProcessor.hashCode());
        return result;
    }

    public String toString() {
        return "BeanConverter(metaProcessor=" + this.getMetaProcessor() + ")";
    }

    public BeanConverter() {
    }

    public BeanConverter(EntityProcessor metaProcessor) {
        this.metaProcessor = metaProcessor;
    }
}

