/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.convertor;

import com.hecloud.runtime.common.collections.Lists;
import com.hecloud.runtime.database.annotation.Column;
import com.hecloud.runtime.database.annotation.Ignore;
import com.hecloud.runtime.database.annotation.PrimaryKey;
import com.hecloud.runtime.database.annotation.Table;
import com.hecloud.runtime.database.cache.SqlCache;
import com.hecloud.runtime.database.emuns.ColumnField;
import com.hecloud.runtime.database.emuns.Strategy;
import com.hecloud.runtime.database.entity.Generic;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class EntityProcessor {
    SqlCache cache = SqlCache.instance();

    public static String fieldToColumn(String filed) {
        if (StringUtils.isEmpty((Object)filed)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(filed);
        int count = 0;
        builder.replace(0, 1, (filed.charAt(0) + "").toLowerCase());
        for (int i = 1; i < filed.length(); ++i) {
            char c = filed.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            builder.replace(i + count, i + count + 1, (c + "").toLowerCase());
            builder.insert(i + count, "_");
            ++count;
        }
        return builder.toString();
    }

    public Strategy getPkStrategy(Object object) {
        return this.getPkStrategy(object.getClass());
    }

    public Strategy getPkStrategy(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fields = clazz.getDeclaredFields();
        this.contact(fieldList, fields);
        if (this.isInherited(clazz)) {
            Field[] superFields = clazz.getSuperclass().getDeclaredFields();
            this.contact(fieldList, superFields);
        }
        return this.getStrategy(fieldList);
    }

    public void setPk(Object bean, Serializable pk) throws Exception {
        List columnFieldList = Optional.ofNullable(this.loadColumnField(bean.getClass())).orElse(new ArrayList());
        for (ColumnField columnField : columnFieldList) {
            if (!columnField.isPk()) continue;
            String fieldName = columnField.getFieldName();
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method method = bean.getClass().getMethod(methodName, columnField.getFieldType());
            method.invoke(bean, pk);
            break;
        }
    }

    public List<ColumnField> loadColumnField(Class<?> clazz) {
        ArrayList<ColumnField> columnFields;
        if (null == this.cache.getEntityCache().get(clazz.getName())) {
            Field[] superFields;
            columnFields = new ArrayList();
            ArrayList totalFields = new ArrayList();
            if (null != clazz.getSuperclass() && null != clazz.getSuperclass().getSuperclass() && clazz.getSuperclass().getSuperclass().equals(Generic.class) && (superFields = clazz.getSuperclass().getDeclaredFields()).length > 0) {
                Arrays.stream(superFields).forEach(field -> totalFields.add(field));
            }
            Field[] fields = clazz.getDeclaredFields();
            Arrays.stream(fields).forEach(field -> totalFields.add(field));
            for (Field field2 : totalFields) {
                ColumnField columnField = new ColumnField();
                columnField.setFieldName(field2.getName());
                columnField.setFieldType(field2.getType());
                if (field2.isAnnotationPresent(Column.class)) {
                    Column column = field2.getAnnotation(Column.class);
                    if (StringUtils.isEmpty((Object)column.value())) {
                        columnField.setColumnName(EntityProcessor.fieldToColumn(field2.getName()));
                    } else {
                        columnField.setColumnName(column.value());
                    }
                    columnField.setFormat(column.format());
                    columnField.setNullable(column.NullAble());
                    columnField.setLength(column.length());
                    columnField.setPk(field2.isAnnotationPresent(PrimaryKey.class));
                    Ignore ignore = field2.getAnnotation(Ignore.class);
                    Optional.ofNullable(ignore).ifPresent(Ignore2 -> {
                        switch (ignore.value()) {
                            case UPDATE: {
                                columnField.setUpdate(false);
                                break;
                            }
                            case INSERT: {
                                columnField.setInsert(false);
                                break;
                            }
                            case ALL: {
                                columnField.setInsert(false);
                                columnField.setUpdate(false);
                                columnField.setIgnore(true);
                                break;
                            }
                        }
                    });
                } else if (field2.isAnnotationPresent(PrimaryKey.class)) {
                    columnField.setPk(true);
                    columnField.setColumnName(EntityProcessor.fieldToColumn(field2.getName()));
                } else {
                    columnField.setInsert(false);
                    columnField.setUpdate(false);
                    columnField.setIgnore(true);
                    columnField.setColumnName(EntityProcessor.fieldToColumn(field2.getName()));
                }
                columnFields.add(columnField);
            }
            this.cache.getEntityCache().put(clazz.getName(), columnFields);
        } else {
            columnFields = (List)this.cache.getEntityCache().get(clazz.getName());
        }
        return columnFields;
    }

    public String loadTableName(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            return table.value();
        }
        return EntityProcessor.fieldToColumn(clazz.getSimpleName());
    }

    public String loadCharset(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            return table.charset();
        }
        return "UTF-8";
    }

    public List<String> loadPk(Class<?> clazz) {
        ArrayList<String> pkList = new ArrayList<String>();
        List<ColumnField> columnFieldList = this.loadColumnField(clazz);
        if (columnFieldList.isEmpty()) {
            return pkList;
        }
        for (ColumnField columnField : columnFieldList) {
            if (!columnField.isPk()) continue;
            pkList.add(columnField.getColumnName());
        }
        return pkList;
    }

    public String loadSinglePk(Class<?> clazz) {
        List<String> pkList = this.loadPk(clazz);
        return pkList.size() == 1 ? pkList.get(0) : null;
    }

    private Strategy getStrategy(List<Field> fields) {
        if (Lists.isEmpty(fields)) {
            return Strategy.SELF;
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(PrimaryKey.class)) continue;
            return field.getAnnotation(PrimaryKey.class).value();
        }
        return Strategy.SELF;
    }

    private boolean isInherited(Class<?> clazz) {
        return null != clazz.getSuperclass() && null != clazz.getSuperclass().getSuperclass() && clazz.getSuperclass().getSuperclass().equals(Generic.class);
    }

    private void contact(List<Field> source, Field[] fields) {
        Optional.ofNullable(source).ifPresent(s -> Optional.ofNullable(fields).ifPresent(fs -> Arrays.stream(fs).filter(field -> !s.contains(field)).forEach(field -> source.add((Field)field))));
    }
}

