/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.core;

import com.hecloud.runtime.common.collections.Maps;
import com.hecloud.runtime.common.exception.DatabaseException;
import com.hecloud.runtime.common.query.Sign;
import com.hecloud.runtime.database.builder.SQLBuilder;
import com.hecloud.runtime.database.convertor.BeanConverter;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import com.hecloud.runtime.database.engine.DataEngine;
import com.hecloud.runtime.database.engine.JdbcEngine;
import com.hecloud.runtime.database.utils.Condition;
import com.hecloud.runtime.database.utils.Conditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class BasicDao
implements InitializingBean {
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    NamedParameterJdbcTemplate npJdbcTemplate;
    private SQLBuilder builder;
    private EntityProcessor processor;
    private BeanConverter converter;
    private DataEngine<?> engine;

    public Object loadEntity(Class<?> clazz, Serializable pk) throws DatabaseException {
        String pkColumn = this.processor.loadSinglePk(clazz);
        Condition condition = Conditions.simple(pkColumn, Sign.EQ);
        Map paramMap = Maps.single((String)pkColumn, (Object)pk);
        return this.queryForEntity(clazz, condition, paramMap);
    }

    public Object saveEntity(Object bean) throws DatabaseException {
        this.engine.save(bean);
        return bean;
    }

    public void execute(String sql) throws DatabaseException {
        this.engine.execute(sql);
    }

    public int update(String sql, Map<String, Object> paramMap) throws DatabaseException {
        return this.engine.execute(sql, paramMap);
    }

    public List<Map<String, Object>> queryForList(String sql) throws DatabaseException {
        return this.engine.list(sql, null);
    }

    public List<Object> queryForList(String sql, Class<?> clazz) throws DatabaseException {
        List<Map<String, Object>> metaList = this.engine.list(sql, null);
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (Map<String, Object> meta : metaList) {
                list.add(this.converter.mapToBean(meta, clazz));
            }
        }
        catch (Throwable e) {
            throw new DatabaseException(e.getLocalizedMessage(), e);
        }
        return list;
    }

    public List<Map<String, Object>> queryForList(String sql, Map<String, Object> paramMap) throws DatabaseException {
        return this.engine.list(sql, paramMap);
    }

    public List<Object> queryForList(String sql, Map<String, Object> paramMap, Class<?> clazz) throws DatabaseException {
        List<Map<String, Object>> metaList = this.engine.list(sql, paramMap);
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (Map<String, Object> meta : metaList) {
                list.add(this.converter.mapToBean(meta, clazz));
            }
        }
        catch (Throwable e) {
            throw new DatabaseException(e.getLocalizedMessage(), e);
        }
        return list;
    }

    public boolean baseSaveEntity(Object bean) throws DatabaseException {
        return this.engine.insert(bean);
    }

    public boolean batchInsert(List<?> beans) throws DatabaseException {
        return this.engine.batchInsert(beans, null);
    }

    public boolean batchInsert(List<?> beans, Integer batchSize) throws DatabaseException {
        return this.engine.batchInsert(beans, batchSize);
    }

    public boolean updateEntity(Object bean) throws DatabaseException {
        return this.engine.update(bean);
    }

    public boolean updateFields(Object bean, String[] fields) throws DatabaseException {
        return this.engine.update(bean, fields);
    }

    public boolean batchUpdate(List<?> objects, Integer batchSize) throws DatabaseException {
        return this.engine.batchUpdate(objects, batchSize);
    }

    public boolean batchUpdate(List<?> objects, String[] fields, Integer batchSize) throws DatabaseException {
        return this.engine.batchUpdate(objects, fields, batchSize);
    }

    public boolean baseDelete(Object bean) throws DatabaseException {
        return this.engine.delete(bean);
    }

    public boolean deleteWithColumn(Object bean, String[] fields) throws DatabaseException {
        return this.engine.delete(bean, fields);
    }

    public Long countQuery(String sql, Map<String, Object> param) throws DatabaseException {
        return this.engine.count(sql, param);
    }

    public Long countQuery(String sql) throws DatabaseException {
        return this.engine.count(sql, null);
    }

    public Long listCount(Class<?> cs, Conditions conditions, Map<String, Object> params) throws DatabaseException {
        return this.engine.count(cs, conditions, params);
    }

    public List<Map<String, Object>> baseQueryForList(Class<?> clazz, Conditions conditions, Map<String, Object> paramMap) throws DatabaseException {
        return this.engine.list(clazz, conditions, paramMap);
    }

    public Object queryForEntity(Class<?> clazz, Condition condition, Map<String, Object> paramMap) throws DatabaseException {
        Map<String, Object> metaMap = this.engine.getEntity(clazz, condition, paramMap);
        Assert.notNull(metaMap, (String)"no data found!");
        try {
            return this.converter.mapToBean(metaMap, clazz);
        }
        catch (Throwable e) {
            throw new DatabaseException(e.getLocalizedMessage(), e);
        }
    }

    public void afterPropertiesSet() throws DatabaseException {
        this.builder = new SQLBuilder();
        this.processor = new EntityProcessor();
        this.converter = new BeanConverter(this.processor);
        this.engine = new JdbcEngine(this.jdbcTemplate, this.npJdbcTemplate, this.builder, this.processor, this.converter);
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNpJdbcTemplate() {
        return this.npJdbcTemplate;
    }

    public SQLBuilder getBuilder() {
        return this.builder;
    }

    public EntityProcessor getProcessor() {
        return this.processor;
    }

    public BeanConverter getConverter() {
        return this.converter;
    }

    public DataEngine<?> getEngine() {
        return this.engine;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setNpJdbcTemplate(NamedParameterJdbcTemplate npJdbcTemplate) {
        this.npJdbcTemplate = npJdbcTemplate;
    }

    public void setBuilder(SQLBuilder builder) {
        this.builder = builder;
    }

    public void setProcessor(EntityProcessor processor) {
        this.processor = processor;
    }

    public void setConverter(BeanConverter converter) {
        this.converter = converter;
    }

    public void setEngine(DataEngine<?> engine) {
        this.engine = engine;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicDao)) {
            return false;
        }
        BasicDao other = (BasicDao)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        if (this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate)) {
            return false;
        }
        NamedParameterJdbcTemplate this$npJdbcTemplate = this.getNpJdbcTemplate();
        NamedParameterJdbcTemplate other$npJdbcTemplate = other.getNpJdbcTemplate();
        if (this$npJdbcTemplate == null ? other$npJdbcTemplate != null : !this$npJdbcTemplate.equals(other$npJdbcTemplate)) {
            return false;
        }
        SQLBuilder this$builder = this.getBuilder();
        SQLBuilder other$builder = other.getBuilder();
        if (this$builder == null ? other$builder != null : !this$builder.equals(other$builder)) {
            return false;
        }
        EntityProcessor this$processor = this.getProcessor();
        EntityProcessor other$processor = other.getProcessor();
        if (this$processor == null ? other$processor != null : !this$processor.equals(other$processor)) {
            return false;
        }
        BeanConverter this$converter = this.getConverter();
        BeanConverter other$converter = other.getConverter();
        if (this$converter == null ? other$converter != null : !((Object)this$converter).equals(other$converter)) {
            return false;
        }
        DataEngine<?> this$engine = this.getEngine();
        DataEngine<?> other$engine = other.getEngine();
        return !(this$engine == null ? other$engine != null : !this$engine.equals(other$engine));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicDao;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        NamedParameterJdbcTemplate $npJdbcTemplate = this.getNpJdbcTemplate();
        result = result * 59 + ($npJdbcTemplate == null ? 43 : $npJdbcTemplate.hashCode());
        SQLBuilder $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
        EntityProcessor $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        BeanConverter $converter = this.getConverter();
        result = result * 59 + ($converter == null ? 43 : ((Object)$converter).hashCode());
        DataEngine<?> $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        return result;
    }

    public String toString() {
        return "BasicDao(jdbcTemplate=" + this.getJdbcTemplate() + ", npJdbcTemplate=" + this.getNpJdbcTemplate() + ", builder=" + this.getBuilder() + ", processor=" + this.getProcessor() + ", converter=" + this.getConverter() + ", engine=" + this.getEngine() + ")";
    }
}

