/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.datasource;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final String DEFAULT = "master";
    private static final String SLAVE = "slave";
    private static final ThreadLocal<LinkedList<String>> DS_HOLDER = ThreadLocal.withInitial(() -> new LinkedList());
    private DataSource master;
    private List<DataSource> slaves;
    private AtomicLong slaveCount = new AtomicLong();
    private int slaveSize = 0;
    private Map<Object, Object> dataSources = new HashMap<Object, Object>();

    public static void useMaster() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6570\u636e\u6e90\u4f7f\u7528:" + DS_HOLDER.get());
        }
        LinkedList<String> sources = DS_HOLDER.get();
        sources.offerFirst(DEFAULT);
    }

    public static void useSlave() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6570\u636e\u6e90\u4f7f\u7528:" + DS_HOLDER.get());
        }
        LinkedList<String> sources = DS_HOLDER.get();
        sources.offerFirst(SLAVE);
    }

    public static void reset() {
        LinkedList<String> sources = DS_HOLDER.get();
        if (logger.isDebugEnabled()) {
            logger.debug("\u91cd\u7f6e\u6570\u636e\u6e90 {}", sources);
        }
        if (sources.size() > 0) {
            sources.poll();
        }
    }

    public void afterPropertiesSet() {
        if (null == this.master) {
            logger.error("\u4e3b\u6570\u636e\u5e93\u52a0\u8f7d\u5931\u8d25\uff01");
            throw new IllegalArgumentException("\u4e3b\u6570\u636e\u5e93\u52a0\u8f7d\u5931\u8d25\uff01");
        }
        this.dataSources.put(DEFAULT, this.master);
        if (null != this.slaves && this.slaves.size() > 0) {
            for (int i = 0; i < this.slaves.size(); ++i) {
                this.dataSources.put(SLAVE + (i + 1), this.slaves.get(i));
            }
            this.slaveSize = this.slaves.size();
        }
        this.setDefaultTargetDataSource(this.master);
        this.setTargetDataSources(this.dataSources);
        super.afterPropertiesSet();
    }

    protected Object determineCurrentLookupKey() {
        String key;
        LinkedList<String> sources = DS_HOLDER.get();
        String string = key = sources.peekFirst() == null ? "" : sources.peekFirst();
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f53\u524d\u6570\u636e\u6e90:" + key);
        }
        switch (key) {
            case "master": {
                return key;
            }
            case "slave": {
                return this.slaveSelect();
            }
        }
        return null;
    }

    private String slaveSelect() {
        if (0 >= this.slaveSize) {
            return null;
        }
        if (this.slaveSize > 1) {
            long c = this.slaveCount.incrementAndGet();
            return SLAVE + ((c %= (long)this.slaveSize) + 1L);
        }
        return "slave1";
    }

    public DataSource getMaster() {
        return this.master;
    }

    public List<DataSource> getSlaves() {
        return this.slaves;
    }

    public AtomicLong getSlaveCount() {
        return this.slaveCount;
    }

    public int getSlaveSize() {
        return this.slaveSize;
    }

    public Map<Object, Object> getDataSources() {
        return this.dataSources;
    }

    public void setMaster(DataSource master) {
        this.master = master;
    }

    public void setSlaves(List<DataSource> slaves) {
        this.slaves = slaves;
    }

    public void setSlaveCount(AtomicLong slaveCount) {
        this.slaveCount = slaveCount;
    }

    public void setSlaveSize(int slaveSize) {
        this.slaveSize = slaveSize;
    }

    public void setDataSources(Map<Object, Object> dataSources) {
        this.dataSources = dataSources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicDataSource)) {
            return false;
        }
        DynamicDataSource other = (DynamicDataSource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DataSource this$master = this.getMaster();
        DataSource other$master = other.getMaster();
        if (this$master == null ? other$master != null : !this$master.equals(other$master)) {
            return false;
        }
        List<DataSource> this$slaves = this.getSlaves();
        List<DataSource> other$slaves = other.getSlaves();
        if (this$slaves == null ? other$slaves != null : !((Object)this$slaves).equals(other$slaves)) {
            return false;
        }
        AtomicLong this$slaveCount = this.getSlaveCount();
        AtomicLong other$slaveCount = other.getSlaveCount();
        if (this$slaveCount == null ? other$slaveCount != null : !this$slaveCount.equals(other$slaveCount)) {
            return false;
        }
        if (this.getSlaveSize() != other.getSlaveSize()) {
            return false;
        }
        Map<Object, Object> this$dataSources = this.getDataSources();
        Map<Object, Object> other$dataSources = other.getDataSources();
        return !(this$dataSources == null ? other$dataSources != null : !((Object)this$dataSources).equals(other$dataSources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicDataSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $master = this.getMaster();
        result = result * 59 + ($master == null ? 43 : $master.hashCode());
        List<DataSource> $slaves = this.getSlaves();
        result = result * 59 + ($slaves == null ? 43 : ((Object)$slaves).hashCode());
        AtomicLong $slaveCount = this.getSlaveCount();
        result = result * 59 + ($slaveCount == null ? 43 : $slaveCount.hashCode());
        result = result * 59 + this.getSlaveSize();
        Map<Object, Object> $dataSources = this.getDataSources();
        result = result * 59 + ($dataSources == null ? 43 : ((Object)$dataSources).hashCode());
        return result;
    }

    public String toString() {
        return "DynamicDataSource(master=" + this.getMaster() + ", slaves=" + this.getSlaves() + ", slaveCount=" + this.getSlaveCount() + ", slaveSize=" + this.getSlaveSize() + ", dataSources=" + this.getDataSources() + ")";
    }
}

