/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.engine;

import com.hecloud.runtime.common.collections.Lists;
import com.hecloud.runtime.common.exception.DatabaseException;
import com.hecloud.runtime.common.model.Result;
import com.hecloud.runtime.database.builder.BatchInsertSQLBuilder;
import com.hecloud.runtime.database.builder.BatchUpdateSQLBuilder;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import com.hecloud.runtime.database.emuns.ColumnField;
import com.hecloud.runtime.database.emuns.Strategy;
import com.hecloud.runtime.database.task.SQLExecuteTask;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BatchEngine {
    private static Logger logger = LoggerFactory.getLogger(BatchEngine.class);
    private static int corePoolSize = Runtime.getRuntime().availableProcessors() * 5;
    private static Integer DEFAULT_SIZE = 1000;
    private JdbcTemplate jdbcTemplate;
    private EntityProcessor processor;

    public BatchEngine(JdbcTemplate jdbcTemplate, EntityProcessor processor) {
        this.jdbcTemplate = jdbcTemplate;
        this.processor = processor;
    }

    public Result batchInsert(List<?> objects, Integer batchSize) throws DatabaseException {
        Object insertSql;
        this.checkNull(objects);
        if (null == batchSize || batchSize <= 0) {
            batchSize = DEFAULT_SIZE;
        }
        Object object = objects.get(0);
        Strategy strategy = this.processor.getPkStrategy(object);
        List<ColumnField> columnFields = this.processor.loadColumnField(object.getClass());
        String tableName = this.processor.loadTableName(object.getClass());
        BatchInsertSQLBuilder batchSQLBuilder = new BatchInsertSQLBuilder(strategy, columnFields, tableName);
        int size = objects.size();
        int grap = size % batchSize;
        int temp = size / batchSize;
        int step = grap == 0 ? temp : temp + 1;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), r -> new Thread(r));
        ExecutorCompletionService<Result> completionService = new ExecutorCompletionService<Result>(executor);
        String prefix = batchSQLBuilder.buildPrefix();
        for (int i = 0; i < step; ++i) {
            String values;
            int startIndex = i * batchSize;
            int stopIndex = (i + 1) * batchSize;
            if (stopIndex >= size) {
                stopIndex = size;
            }
            if (StringUtils.isEmpty((Object)(values = batchSQLBuilder.buildValues(objects.subList(startIndex, stopIndex))))) {
                logger.warn("No values exist\uff01");
                continue;
            }
            insertSql = prefix + values;
            completionService.submit(new SQLExecuteTask((String)insertSql, this.jdbcTemplate));
        }
        try {
            for (int index = 0; index < step; ++index) {
                if (((Result)completionService.take().get()).isSuccess()) {
                    continue;
                }
                insertSql = new Result(false, "\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01");
                return insertSql;
            }
            insertSql = new Result(true, "\u6279\u91cf\u6dfb\u52a0\u6210\u529f\uff01");
            return insertSql;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DatabaseException("\u6279\u91cf\u6dfb\u52a0\u5f02\u5e38", (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
    }

    public Result batchUpdate(List<?> objects, String[] fields, Integer batchSize) throws DatabaseException {
        this.checkNull(objects);
        if (null == batchSize || batchSize <= 0) {
            batchSize = DEFAULT_SIZE;
        }
        Object object = objects.get(0);
        Strategy strategy = this.processor.getPkStrategy(object);
        List<ColumnField> columnFields = this.processor.loadColumnField(object.getClass());
        String tableName = this.processor.loadTableName(object.getClass());
        ColumnField pk = this.getPK(columnFields);
        Assert.notNull((Object)pk, (String)"PK is null !");
        BatchUpdateSQLBuilder batchSQLBuilder = new BatchUpdateSQLBuilder(strategy, columnFields, tableName, fields, pk);
        int size = objects.size();
        int grap = size % batchSize;
        int temp = size / batchSize;
        int step = grap == 0 ? temp : temp + 1;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), runnable -> new Thread(runnable));
        ExecutorCompletionService<Result> completionService = new ExecutorCompletionService<Result>(executor);
        String prefix = batchSQLBuilder.buildPrefix();
        for (int i = 0; i < step; ++i) {
            int startIndex = i * batchSize;
            int stopIndex = (i + 1) * batchSize;
            if (stopIndex >= size) {
                stopIndex = size;
            }
            String values = batchSQLBuilder.buildValues(objects.subList(startIndex, stopIndex));
            completionService.submit(new SQLExecuteTask(prefix + values, this.jdbcTemplate));
        }
        try {
            for (int index = 0; index < step; ++index) {
                if (((Result)completionService.take().get()).isSuccess()) {
                    continue;
                }
                Result result = new Result(false, "\u6279\u91cf\u66f4\u65b0\u5931\u8d25\uff01");
                return result;
            }
            Result result = new Result(true, "\u6279\u91cf\u66f4\u65b0\u6210\u529f\uff01");
            return result;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DatabaseException("\u6279\u91cf\u66f4\u65b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
    }

    private void checkNull(List<?> objects) throws DatabaseException {
        if (Lists.allNull(objects)) {
            throw new DatabaseException("No Object need to be Insert!", new Throwable());
        }
    }

    private ColumnField getPK(List<ColumnField> columnFields) {
        if (Lists.isEmpty(columnFields)) {
            return null;
        }
        return columnFields.stream().filter(columnField -> columnField.isPk()).findFirst().get();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public EntityProcessor getProcessor() {
        return this.processor;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setProcessor(EntityProcessor processor) {
        this.processor = processor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchEngine)) {
            return false;
        }
        BatchEngine other = (BatchEngine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        if (this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate)) {
            return false;
        }
        EntityProcessor this$processor = this.getProcessor();
        EntityProcessor other$processor = other.getProcessor();
        return !(this$processor == null ? other$processor != null : !this$processor.equals(other$processor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchEngine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        EntityProcessor $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        return result;
    }

    public String toString() {
        return "BatchEngine(jdbcTemplate=" + this.getJdbcTemplate() + ", processor=" + this.getProcessor() + ")";
    }
}

