/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.engine;

import com.hecloud.runtime.common.collections.Lists;
import com.hecloud.runtime.common.collections.Maps;
import com.hecloud.runtime.common.exception.DatabaseException;
import com.hecloud.runtime.common.generator.IDFactory;
import com.hecloud.runtime.common.query.Sign;
import com.hecloud.runtime.database.builder.EntityBuilder;
import com.hecloud.runtime.database.builder.SQLBuilder;
import com.hecloud.runtime.database.builder.SelectBuilder;
import com.hecloud.runtime.database.convertor.BeanConverter;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import com.hecloud.runtime.database.core.ExtPropertySqlParameterSource;
import com.hecloud.runtime.database.emuns.Strategy;
import com.hecloud.runtime.database.engine.BatchEngine;
import com.hecloud.runtime.database.engine.DataEngine;
import com.hecloud.runtime.database.utils.Condition;
import com.hecloud.runtime.database.utils.Conditions;
import com.hecloud.runtime.database.validator.InjectionAssert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.Assert;

public class JdbcEngine<T>
implements DataEngine<T> {
    private static final Logger log = LoggerFactory.getLogger(JdbcEngine.class);
    private static final String SQL_INJECTION = "SQL_INJECT_RISK";
    private static IDFactory idFactory = IDFactory.instance();
    private NamedParameterJdbcTemplate npJdbcTemplate;
    private JdbcTemplate jdbcTemplate;
    private EntityProcessor processor;
    private BeanConverter converter;
    private SQLBuilder builder;

    public JdbcEngine(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate npJdbcTemplate, SQLBuilder builder, EntityProcessor processor, BeanConverter converter) {
        this.jdbcTemplate = jdbcTemplate;
        this.npJdbcTemplate = npJdbcTemplate;
        this.builder = builder;
        this.processor = processor;
        this.converter = converter;
    }

    @Override
    public boolean insert(Object object) throws DatabaseException {
        try {
            Assert.notNull((Object)object, (String)"record need to insert is null!");
            EntityBuilder.builder().build().beforeInsert(object);
            String sql = this.builder.buildInsert(object.getClass());
            ExtPropertySqlParameterSource sps = new ExtPropertySqlParameterSource(object);
            return this.npJdbcTemplate.update(sql, (SqlParameterSource)sps) > 0;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean batchInsert(List<?> objects) throws DatabaseException {
        try {
            Assert.notNull(objects, (String)"records need to insert is null!");
            EntityBuilder builder = EntityBuilder.builder().build();
            objects.forEach(builder::beforeInsert);
            BatchEngine engine = new BatchEngine(this.jdbcTemplate, this.processor);
            return engine.batchInsert(objects, 1000).isSuccess();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean batchInsert(List<?> objects, Integer batchSize) throws DatabaseException {
        try {
            Assert.notNull(objects, (String)"records need to insert is null!");
            BatchEngine engine = new BatchEngine(this.jdbcTemplate, this.processor);
            EntityBuilder builder = EntityBuilder.builder().build();
            objects.forEach(builder::beforeInsert);
            return engine.batchInsert(objects, batchSize).isSuccess();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void save(Object object) throws DatabaseException {
        try {
            Assert.notNull((Object)object, (String)"record need to save is null!");
            EntityBuilder.builder().build().beforeInsert(object);
            Strategy strategy = Optional.ofNullable(this.processor.getPkStrategy(object)).orElse(Strategy.AUTO);
            switch (strategy) {
                case UUID: {
                    try {
                        this.processor.setPk(object, (Serializable)((Object)idFactory.uuid()));
                        break;
                    }
                    catch (Exception e) {
                        throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            String sql = this.builder.buildInsert(object.getClass());
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            ExtPropertySqlParameterSource paramSource = new ExtPropertySqlParameterSource(object);
            this.npJdbcTemplate.update(sql, (SqlParameterSource)paramSource, (KeyHolder)keyHolder);
            switch (strategy) {
                case AUTO: {
                    try {
                        Number keyValue = keyHolder.getKey();
                        Assert.notNull((Object)keyValue, (String)"get fallback key is exception!");
                        this.processor.setPk(object, Long.valueOf(keyValue.longValue()));
                        break;
                    }
                    catch (Exception e) {
                        throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e, "");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean update(Object object) throws DatabaseException {
        try {
            Assert.notNull((Object)object, (String)"record need to insert is null!");
            EntityBuilder.builder().build().beforeUpdate(object);
            String sql = this.builder.buildUpdate(object.getClass());
            ExtPropertySqlParameterSource sps = new ExtPropertySqlParameterSource(object);
            return this.npJdbcTemplate.update(sql, (SqlParameterSource)sps) > 0;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean update(Object object, String[] fields) throws DatabaseException {
        try {
            Assert.notNull((Object)object, (String)"record need to update is null!");
            EntityBuilder.builder().build().beforeUpdate(object);
            String sql = this.builder.buildUpdateSqlByColumns(object.getClass(), fields);
            ExtPropertySqlParameterSource sps = new ExtPropertySqlParameterSource(object);
            return this.npJdbcTemplate.update(sql, (SqlParameterSource)sps) > 0;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean batchUpdate(List<?> objects) throws DatabaseException {
        Assert.noNullElements(objects, (String)"objects need to update is null!");
        EntityBuilder builder = EntityBuilder.builder().build();
        objects.forEach(builder::beforeUpdate);
        return this.batchUpdate(objects, null, null);
    }

    @Override
    public boolean batchUpdate(List<?> objects, String[] fields) throws DatabaseException {
        Assert.noNullElements(objects, (String)"objects need to update is null!");
        EntityBuilder builder = EntityBuilder.builder().build();
        objects.forEach(builder::beforeUpdate);
        return this.batchUpdate(objects, fields, null);
    }

    @Override
    public boolean batchUpdate(List<?> objects, Integer batchSize) throws DatabaseException {
        Assert.noNullElements(objects, (String)"objects need to update is null!");
        EntityBuilder builder = EntityBuilder.builder().build();
        objects.forEach(builder::beforeUpdate);
        return this.batchUpdate(objects, null, batchSize);
    }

    @Override
    public boolean batchUpdate(List<?> objects, String[] fields, Integer batchSize) throws DatabaseException {
        try {
            Assert.notNull(objects, (String)"records need to update is null!");
            EntityBuilder builder = EntityBuilder.builder().build();
            objects.forEach(builder::beforeUpdate);
            BatchEngine engine = new BatchEngine(this.jdbcTemplate, this.processor);
            return engine.batchUpdate(objects, fields, batchSize).isSuccess();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public Object load(Class<?> clazz, Serializable pk) throws DatabaseException {
        try {
            String pkColumn = this.processor.loadSinglePk(clazz);
            Assert.notNull((Object)pkColumn, (String)"No Primary Key Exist Or MultiKey!");
            Condition condition = Conditions.simple(pkColumn, Sign.EQ);
            Map param = Maps.single((String)pkColumn, (Object)pk);
            Map<String, Object> metaMap = this.getEntity(clazz, condition, param);
            return Maps.isEmpty(metaMap) ? null : this.converter.mapToBean(metaMap, clazz);
        }
        catch (Throwable e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Map<String, Object> getEntity(Class<?> clazz, Condition condition, Map<String, Object> params) throws DatabaseException {
        try {
            Optional.ofNullable(params).ifPresent(param -> InjectionAssert.assertValidate(params, SQL_INJECTION));
            String select = SelectBuilder.builder().build().select("*").from(clazz).where("1=1").and(condition.build()).sql();
            InjectionAssert.assertValidate(select, SQL_INJECTION);
            List list = this.npJdbcTemplate.queryForList(select, params);
            Assert.notEmpty((Collection)list, (String)"no data found!");
            Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)SQL_INJECTION);
            return (Map)list.get(0);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void execute(String sql) throws DatabaseException {
        try {
            this.jdbcTemplate.execute(sql);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public int execute(String sql, Map<String, Object> params) throws DatabaseException {
        try {
            Optional.ofNullable(params).ifPresent(param -> InjectionAssert.assertValidate(params, SQL_INJECTION));
            return this.npJdbcTemplate.update(sql, params);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> list(String sql, Map<String, Object> params) throws DatabaseException {
        try {
            InjectionAssert.assertValidate(sql, SQL_INJECTION);
            if (null == params || params.isEmpty()) {
                return this.jdbcTemplate.queryForList(sql);
            }
            InjectionAssert.assertValidate(params, SQL_INJECTION);
            return this.npJdbcTemplate.queryForList(sql, params);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> list(Class<?> clazz, Conditions conditions, Map<String, Object> paramMap) throws DatabaseException {
        try {
            Optional.ofNullable(paramMap).ifPresent(param -> InjectionAssert.assertValidate(paramMap, SQL_INJECTION));
            String select = SelectBuilder.builder().build().select("*").from(clazz).where("1=1").and(conditions.build()).sql();
            InjectionAssert.assertValidate(select, SQL_INJECTION);
            List metaList = this.npJdbcTemplate.queryForList(select, paramMap);
            return Lists.isEmpty((List)metaList) ? new ArrayList() : metaList;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public Long count(String sql, Map<String, Object> params) throws DatabaseException {
        try {
            InjectionAssert.assertValidate(sql, SQL_INJECTION);
            Optional.ofNullable(params).ifPresent(param -> InjectionAssert.assertValidate(params, SQL_INJECTION));
            return (Long)this.npJdbcTemplate.queryForObject(sql, params, Long.class);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public Long count(Class<?> clazz, Conditions conditions, Map<String, Object> params) throws DatabaseException {
        try {
            Optional.ofNullable(params).ifPresent(param -> InjectionAssert.assertValidate(params, SQL_INJECTION));
            String count = SelectBuilder.builder().build().select("COUNT(*)").from(clazz).where("1=1").and(conditions.build()).sql();
            InjectionAssert.assertValidate(count, SQL_INJECTION);
            return this.count(count, params);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean delete(Class<?> clazz, Serializable id) throws DatabaseException {
        try {
            Assert.notNull((Object)id, (String)"primary key is null!");
            String sql = this.builder.buildDelete(clazz);
            Object bean = clazz.newInstance();
            this.processor.setPk(bean, id);
            ExtPropertySqlParameterSource sps = new ExtPropertySqlParameterSource(bean);
            return this.npJdbcTemplate.update(sql, (SqlParameterSource)sps) > 0;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean delete(Object object, String[] fields) throws DatabaseException {
        try {
            Assert.notNull((Object)object, (String)"object need to delete is null!");
            String sql = this.builder.buildDeleteByColumns(object.getClass(), fields);
            ExtPropertySqlParameterSource sps = new ExtPropertySqlParameterSource(object);
            return this.npJdbcTemplate.update(sql, (SqlParameterSource)sps) > 0;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean delete(Object object) throws DatabaseException {
        try {
            Assert.notNull((Object)object, (String)"object need to delete is null!");
            String sql = this.builder.buildDelete(object.getClass());
            ExtPropertySqlParameterSource sps = new ExtPropertySqlParameterSource(object);
            return this.npJdbcTemplate.update(sql, (SqlParameterSource)sps) > 0;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            throw new DatabaseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

