/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.utils;

import com.hecloud.runtime.common.collections.Lists;
import com.hecloud.runtime.common.enums.Relation;
import com.hecloud.runtime.common.query.Sign;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import com.hecloud.runtime.database.emuns.ColumnField;
import com.hecloud.runtime.database.utils.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Conditions {
    public static final String WHERE = "WHERE 1=1 AND ";
    private Map<Relation, List<Condition>> data;

    public static Condition simple(ColumnField field, Sign sign) {
        return new Condition(field, sign);
    }

    public static Condition simple(String field, Sign sign) {
        ColumnField columnField = new ColumnField(field, EntityProcessor.fieldToColumn(field), Integer.MAX_VALUE, false, false, true, true, false, false, Object.class, null);
        return Conditions.simple(columnField, sign);
    }

    public Conditions add(Relation relation, ColumnField field, Sign sign) {
        List<Condition> conditions;
        if (null == this.data) {
            this.data = new HashMap<Relation, List<Condition>>(3);
        }
        if (this.data.containsKey(relation)) {
            conditions = this.data.get(relation);
            if (this.exist(conditions, Optional.of(field), sign)) {
                return this;
            }
        } else {
            conditions = new ArrayList<Condition>();
        }
        conditions.add(new Condition(field, sign));
        this.data.put(relation, conditions);
        return this;
    }

    public Conditions add(Relation relation, String field, Sign sign) {
        ColumnField columnField = new ColumnField(field, EntityProcessor.fieldToColumn(field), Integer.MAX_VALUE, false, false, true, true, true, false, Object.class, null);
        return this.add(relation, columnField, sign);
    }

    public String build() {
        if (null == this.data || this.data.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(WHERE);
        if (this.data.keySet().size() == 1) {
            Relation relation = this.data.keySet().iterator().next();
            List<Condition> conditions = this.data.get(relation);
            builder.append(this.sameRelation(relation, conditions));
            return builder.toString();
        }
        Iterator<Relation> iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            Relation relation = iterator.next();
            List<Condition> conditions = this.data.get(relation);
            builder.append("(").append(this.sameRelation(relation, conditions)).append(")");
            if (!iterator.hasNext()) continue;
            builder.append(" ").append(Relation.AND.getRelation()).append(" ");
        }
        return builder.toString();
    }

    private String sameRelation(Relation relation, List<Condition> conditions) {
        StringBuilder builder = new StringBuilder();
        for (Condition condition : conditions) {
            builder.append(condition.build());
            if (conditions.indexOf(condition) == conditions.size() - 1) continue;
            builder.append(" ").append(relation.getRelation()).append(" ");
        }
        return builder.toString();
    }

    private boolean exist(List<Condition> conditions, Optional<ColumnField> field, Sign sign) {
        if (field.isPresent()) {
            if (Lists.isEmpty(conditions)) {
                return false;
            }
            for (Condition condition : conditions) {
                if (!condition.getField().getColumnName().equalsIgnoreCase(field.get().getColumnName()) || !condition.getSign().equals((Object)sign)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Map<Relation, List<Condition>> getData() {
        return this.data;
    }

    public void setData(Map<Relation, List<Condition>> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conditions)) {
            return false;
        }
        Conditions other = (Conditions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Relation, List<Condition>> this$data = this.getData();
        Map<Relation, List<Condition>> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conditions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Relation, List<Condition>> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Conditions(data=" + this.getData() + ")";
    }

    public Conditions() {
    }

    public Conditions(Map<Relation, List<Condition>> data) {
        this.data = data;
    }
}

