/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.validator;

import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class InjectionAssert {
    private static String paramInjectRegex = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)";
    private static String queryInjectRegex = "(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(create|alter|update|delete|insert|trancate|drop|execute)\\b)";
    private static Pattern paramInjectPattern = Pattern.compile(paramInjectRegex, 2);
    private static Pattern queryInjectPattern = Pattern.compile(queryInjectRegex, 2);

    public static void assertValidate(Map<String, Object> params, String message) {
        if (null == params || params.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (StringUtils.hasText((String)entry.getKey()) && paramInjectPattern.matcher(entry.getKey()).find()) {
                throw new IllegalArgumentException(message);
            }
            if (null == entry.getValue() || !paramInjectPattern.matcher(entry.getValue().toString()).find()) continue;
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertValidate(String sql, String message) {
        Assert.hasLength((String)sql, (String)"SQL\u8bed\u53e5\u4e3a\u7a7a\uff01");
        if (queryInjectPattern.matcher(sql).find()) {
            throw new IllegalArgumentException(message);
        }
    }
}

