/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.builder;

import com.alibaba.fastjson.JSONObject;
import com.hecloud.runtime.common.collections.Lists;
import com.hecloud.runtime.common.exception.DatabaseException;
import com.hecloud.runtime.database.builder.BatchSQLBuilder;
import com.hecloud.runtime.database.emuns.ColumnField;
import com.hecloud.runtime.database.emuns.Strategy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BatchUpdateSQLBuilder
implements BatchSQLBuilder {
    private Strategy strategy;
    private List<ColumnField> columnFields;
    private String tableName;
    private String[] fields;
    private ColumnField pk;
    private SimpleDateFormat dateFormat;

    public BatchUpdateSQLBuilder(Strategy strategy, List<ColumnField> columnFields, String tableName, String[] fields, ColumnField pk) {
        this.strategy = strategy;
        this.columnFields = columnFields;
        this.tableName = tableName;
        this.pk = pk;
        this.processFields(fields);
    }

    @Override
    public String buildValues(List<?> objects) throws DatabaseException {
        String field;
        objects = Optional.ofNullable(objects).orElse(new ArrayList());
        Assert.isTrue((!Lists.isEmpty(objects = objects.stream().filter(object -> null != object && !JSONObject.parseObject((String)JSONObject.toJSONString((Object)object)).isEmpty()).collect(Collectors.toList())) ? 1 : 0) != 0, (String)"records needed to update is null");
        StringBuilder builder = new StringBuilder();
        for (Object object2 : objects) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(object2));
            builder.append("(");
            if (null == jsonObject.get((Object)this.pk.getFieldName())) {
                throw new DatabaseException("primary key does not have value!", new Throwable());
            }
            if (jsonObject.get((Object)this.pk.getFieldName()) instanceof String) {
                builder.append(this.around(jsonObject.getString(this.pk.getFieldName()))).append(",");
            } else {
                builder.append(jsonObject.get((Object)this.pk.getFieldName()).toString()).append(",");
            }
            for (ColumnField columnField : this.columnFields) {
                if (columnField.isPk() || !columnField.isInsert()) continue;
                field = columnField.getFieldName();
                if (columnField.getFieldType().equals(String.class)) {
                    builder.append(this.around(jsonObject.getString(field))).append(",");
                    continue;
                }
                if (columnField.getFieldType().equals(Date.class)) {
                    this.dateFormat = new SimpleDateFormat(columnField.getFormat());
                    Date date = jsonObject.getDate(field);
                    if (null == date) {
                        if (columnField.isNullable()) {
                            builder.append("null").append(",");
                            continue;
                        }
                        builder.append(this.around(this.dateFormat.format(new Date()))).append(",");
                        continue;
                    }
                    builder.append(this.around(this.dateFormat.format(jsonObject.getDate(field)))).append(",");
                    continue;
                }
                builder.append(jsonObject.get((Object)field)).append(",");
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append("),");
        }
        builder.delete(builder.length() - 1, builder.length());
        builder.append(" ON DUPLICATE KEY UPDATE ");
        StringBuilder updateFieldBuilder = new StringBuilder();
        for (ColumnField columnField : this.columnFields) {
            if (columnField.isPk() || !columnField.isUpdate() || !com.hecloud.runtime.common.collections.Arrays.exits((Object)(field = columnField.getFieldName()), (Object[])this.getFields())) continue;
            updateFieldBuilder.append(columnField.getColumnName()).append("=VALUES(`").append(columnField.getColumnName()).append("`),");
        }
        updateFieldBuilder.delete(updateFieldBuilder.length() - 1, updateFieldBuilder.length());
        builder.append((CharSequence)updateFieldBuilder);
        return builder.toString();
    }

    @Override
    public String buildPrefix() {
        StringBuilder buffer = new StringBuilder();
        StringBuilder columns = new StringBuilder("`");
        columns.append(this.pk.getColumnName()).append("`,`");
        for (ColumnField columnFiled : this.columnFields) {
            if (columnFiled.isPk() || columnFiled.isIgnore() || !columnFiled.isInsert()) continue;
            columns.append(columnFiled.getColumnName()).append("`,`");
        }
        columns.deleteCharAt(columns.length() - 1);
        columns.deleteCharAt(columns.length() - 1);
        buffer.append("insert into ").append(this.tableName).append(" (");
        buffer.append((CharSequence)columns);
        buffer.append(") values ");
        return buffer.toString();
    }

    private void processFields(String[] fields) {
        ArrayList<String> updateFields = new ArrayList<String>();
        if (com.hecloud.runtime.common.collections.Arrays.isEmpty((Object[])fields)) {
            for (ColumnField columnField : this.columnFields) {
                if (!columnField.isUpdate()) continue;
                updateFields.add(columnField.getFieldName());
            }
            this.fields = new String[updateFields.size()];
            for (int i = 0; i < updateFields.size(); ++i) {
                this.fields[i] = (String)updateFields.get(i);
            }
        } else {
            this.fields = fields;
        }
    }

    private String around(String value) {
        return StringUtils.isEmpty((Object)value) ? "null" : "'" + value + "'";
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public List<ColumnField> getColumnFields() {
        return this.columnFields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getFields() {
        return this.fields;
    }

    public ColumnField getPk() {
        return this.pk;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void setColumnFields(List<ColumnField> columnFields) {
        this.columnFields = columnFields;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public void setPk(ColumnField pk) {
        this.pk = pk;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchUpdateSQLBuilder)) {
            return false;
        }
        BatchUpdateSQLBuilder other = (BatchUpdateSQLBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        List<ColumnField> this$columnFields = this.getColumnFields();
        List<ColumnField> other$columnFields = other.getColumnFields();
        if (this$columnFields == null ? other$columnFields != null : !((Object)this$columnFields).equals(other$columnFields)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFields(), other.getFields())) {
            return false;
        }
        ColumnField this$pk = this.getPk();
        ColumnField other$pk = other.getPk();
        if (this$pk == null ? other$pk != null : !((Object)this$pk).equals(other$pk)) {
            return false;
        }
        SimpleDateFormat this$dateFormat = this.getDateFormat();
        SimpleDateFormat other$dateFormat = other.getDateFormat();
        return !(this$dateFormat == null ? other$dateFormat != null : !((Object)this$dateFormat).equals(other$dateFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchUpdateSQLBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        List<ColumnField> $columnFields = this.getColumnFields();
        result = result * 59 + ($columnFields == null ? 43 : ((Object)$columnFields).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        ColumnField $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : ((Object)$pk).hashCode());
        SimpleDateFormat $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : ((Object)$dateFormat).hashCode());
        return result;
    }

    public String toString() {
        return "BatchUpdateSQLBuilder(strategy=" + (Object)((Object)this.getStrategy()) + ", columnFields=" + this.getColumnFields() + ", tableName=" + this.getTableName() + ", fields=" + Arrays.deepToString(this.getFields()) + ", pk=" + this.getPk() + ", dateFormat=" + this.getDateFormat() + ")";
    }
}

