/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBuilder {
    private static final Logger log = LoggerFactory.getLogger(EntityBuilder.class);
    private static final String CREATE = "gmtCreate";
    private static final String MODIFY = "gmtModify";
    private static final String DELETE = "deleted";

    public void beforeInsert(Object target) {
        try {
            if (this.contains(target.getClass(), CREATE)) {
                Method setGmtCreateMethod = target.getClass().getMethod("setGmtCreate", Date.class);
                setGmtCreateMethod.invoke(target, new Date());
            }
            if (this.contains(target.getClass(), MODIFY)) {
                Method setGmtModifyMethod = target.getClass().getMethod("setGmtModify", Date.class);
                setGmtModifyMethod.invoke(target, new Date());
            }
            if (this.contains(target.getClass(), DELETE)) {
                Method setDeletedMethod = target.getClass().getMethod("setDeleted", Boolean.class);
                setDeletedMethod.invoke(target, false);
            }
        }
        catch (Exception e) {
            log.error("before create method processing occur exception!", (Throwable)e);
        }
    }

    public void beforeUpdate(Object target) {
        try {
            if (this.contains(target.getClass(), MODIFY)) {
                Method setGmtModifyMethod = target.getClass().getMethod("setGmtModify", Date.class);
                setGmtModifyMethod.invoke(target, new Date());
            }
        }
        catch (Exception e) {
            log.error("before modify method processing occur exception!", (Throwable)e);
        }
    }

    private boolean contains(Class clazz, String field) {
        Field[] fields = clazz.getDeclaredFields();
        Field[] parent = Optional.ofNullable(clazz.getSuperclass().getDeclaredFields()).orElse(new Field[0]);
        ArrayList fieldNames = new ArrayList();
        Arrays.stream(fields).forEach(f -> fieldNames.add(f.getName()));
        Arrays.stream(parent).forEach(f -> fieldNames.add(f.getName()));
        return fieldNames.contains(field);
    }

    EntityBuilder() {
    }

    public static EntityBuilderBuilder builder() {
        return new EntityBuilderBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityBuilder)) {
            return false;
        }
        EntityBuilder other = (EntityBuilder)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityBuilder;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "EntityBuilder()";
    }

    public static class EntityBuilderBuilder {
        EntityBuilderBuilder() {
        }

        public EntityBuilder build() {
            return new EntityBuilder();
        }

        public String toString() {
            return "EntityBuilder.EntityBuilderBuilder()";
        }
    }
}

