/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.builder;

import com.hecloud.runtime.common.collections.Maps;
import com.hecloud.runtime.common.enums.Relation;
import com.hecloud.runtime.common.query.Page;
import com.hecloud.runtime.common.query.Param;
import com.hecloud.runtime.common.query.Sign;
import com.hecloud.runtime.database.builder.LikeBuilder;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class QueryBuilder {
    public static String build(String sql, Page page, String tag) {
        StringBuilder builder = new StringBuilder(QueryBuilder.build(sql, page.getParams(), page.getSorter(), tag));
        builder.append(QueryBuilder.buildPage(page.getPage(), page.getRows()));
        return builder.toString();
    }

    public static String buildRaw(String sql, Page page, String tag) {
        StringBuilder builder = new StringBuilder(QueryBuilder.buildRaw(sql, page.getParams(), page.getSorter(), tag));
        builder.append(QueryBuilder.buildPage(page.getPage(), page.getRows()));
        return builder.toString();
    }

    public static String build(String sql, List<Param> params, Map<String, String> sorter, String tag) {
        StringBuilder builder = new StringBuilder(sql);
        String alias = StringUtils.hasText((String)tag) ? tag + "." : "";
        params = Optional.ofNullable(params).orElse(new ArrayList());
        params.forEach(param -> QueryBuilder.processParam(builder, param, alias));
        builder.append(QueryBuilder.buildSort(sorter, alias));
        return builder.toString();
    }

    public static String buildByPlaceHolder(String source, Map<String, Object> paramMap) {
        if (Maps.isEmpty(paramMap)) {
            return source;
        }
        StringBuilder builder = new StringBuilder(source);
        if (!source.toUpperCase().contains(" WHERE ")) {
            builder.append(" WHERE 1=1");
        }
        paramMap.keySet().stream().filter(key -> Objects.nonNull(paramMap.get(key))).forEach(key -> builder.append(" AND ").append((String)key).append(" =:").append((String)key));
        return builder.toString();
    }

    private static void processParam(StringBuilder builder, Param param, String tag) {
        Sign sign = param.getSign();
        Relation relation = param.getRelation();
        if (param.isSub()) {
            builder.append(" ").append(param.getRelation().getRelation());
            QueryBuilder.processSubParam(builder, param, tag);
            return;
        }
        switch (sign) {
            case NUL: {
                for (String key : param.getParam().keySet()) {
                    builder.append(" ").append(relation.getRelation()).append(" ").append(tag).append(QueryBuilder.fieldToColumn(key)).append(" ").append(sign.getSign());
                }
                break;
            }
            case LK: {
                QueryBuilder.processLike(param, LikeMode.FULL);
                QueryBuilder.assembleParam(builder, param, tag);
                break;
            }
            default: {
                QueryBuilder.assembleParam(builder, param, tag);
            }
        }
    }

    private static void processSubParam(StringBuilder builder, Param param, String tag) {
        StringBuilder subBuilder = new StringBuilder();
        Param specialParam = null;
        String prefix = null;
        int index = 0;
        for (Param subParam : param.getSubParams()) {
            if (++index == 1 && Relation.OR.equals((Object)subParam.getRelation())) {
                specialParam = subParam;
                continue;
            }
            QueryBuilder.assembleSubParam(subBuilder, subParam, tag);
            if (index != 1 && index != 2 || !StringUtils.isEmpty(prefix)) continue;
            prefix = subParam.getRelation().getRelation();
        }
        Optional.ofNullable(specialParam).ifPresent(sp -> QueryBuilder.assembleSubParam(subBuilder, sp, tag));
        Optional.ofNullable(prefix).ifPresent(data -> subBuilder.delete(0, data.length() + 1));
        builder.append(" ").append("(").append((CharSequence)subBuilder).append(" ").append(")");
    }

    private static void assembleSubParam(StringBuilder builder, Param param, String tag) {
        tag = Optional.ofNullable(tag).orElse("");
        Set keys = param.getParam().keySet();
        for (String key : keys) {
            builder.append(" ").append(param.getRelation().getRelation()).append(" ").append(tag).append(QueryBuilder.fieldToColumn(key)).append(" ").append(param.getSign().getSign());
            if (Sign.NUL.equals((Object)param.getSign())) continue;
            builder.append(":").append(key).append(" ");
        }
    }

    private static void assembleParam(StringBuilder builder, Param param, String tag) {
        Map map = param.getParam();
        for (String key : map.keySet()) {
            builder.append(" " + param.getRelation().getRelation() + " " + tag + QueryBuilder.fieldToColumn(key) + " " + param.getSign().getSign() + ":" + key);
            if (!Sign.LK.equals((Object)param.getSign()) || !((String)map.get(key)).contains("!_")) continue;
            builder.append(" escape '!'");
        }
    }

    private static void processLike(Param param, LikeMode likeMode) {
        if (null == param) {
            return;
        }
        if (Sign.LK.equals((Object)param.getSign())) {
            Map map = param.getParam();
            if (null == map || map.isEmpty()) {
                return;
            }
            for (String key : map.keySet()) {
                String queryValue = (String)map.get(key);
                if (StringUtils.isEmpty((Object)queryValue)) continue;
                switch (likeMode) {
                    case FULL: {
                        queryValue = LikeBuilder.full(queryValue);
                        break;
                    }
                    case RIGHT: {
                        queryValue = LikeBuilder.right(queryValue);
                        break;
                    }
                    case LEFT: {
                        queryValue = LikeBuilder.left(queryValue);
                        break;
                    }
                }
                if (queryValue.contains("_")) {
                    queryValue = queryValue.replaceAll("_", "!_");
                }
                map.put(key, queryValue);
            }
        }
    }

    public static String buildRaw(String sql, List<Param> params, Map<String, String> sorter, String tag) {
        StringBuffer buffer = new StringBuffer(sql);
        tag = StringUtils.hasText((String)tag) ? tag + "." : "";
        buffer.append(QueryBuilder.buildCondition(params, tag));
        buffer.append(QueryBuilder.buildSort(sorter, tag));
        return buffer.toString();
    }

    public static String buildCondition(List<Param> params, String tag) {
        params = Optional.ofNullable(params).orElse(new ArrayList(0));
        StringBuilder builder = new StringBuilder();
        block7: for (Param param : params) {
            Sign sign = param.getSign();
            switch (sign) {
                case LK: {
                    for (String key : param.getParam().keySet()) {
                        builder.append(QueryBuilder.common(param, tag, key));
                        String value = LikeBuilder.full(param.getParam().get(key).toString());
                        if (value.contains("_")) {
                            value = value.replaceAll("_", "!_");
                            builder.append(" ").append("'").append(value).append("'").append(" escape '!'");
                            continue;
                        }
                        builder.append(" ").append("'").append(value).append("'");
                    }
                    continue block7;
                }
                case IN: {
                    for (String key : param.getParam().keySet()) {
                        builder.append(QueryBuilder.common(param, tag, key)).append(" ").append("(").append(param.getParam().get(key).toString()).append(")");
                    }
                    continue block7;
                }
                case GET: {
                    for (String key : param.getParam().keySet()) {
                        builder.append(QueryBuilder.common(param, tag, key)).append(" ").append("'").append(param.getParam().get(key).toString()).append("'");
                    }
                    continue block7;
                }
                case LET: {
                    for (String key : param.getParam().keySet()) {
                        builder.append(QueryBuilder.common(param, tag, key)).append(" ").append("'").append(param.getParam().get(key).toString()).append("'");
                    }
                    continue block7;
                }
                case NUL: {
                    for (String key : param.getParam().keySet()) {
                        builder.append(QueryBuilder.common(param, tag, key));
                    }
                    continue block7;
                }
                default: {
                    for (String key : param.getParam().keySet()) {
                        if (param.getParam().get(key) instanceof Boolean) {
                            builder.append(QueryBuilder.common(param, tag, key)).append(" ").append(param.getParam().get(key));
                            continue;
                        }
                        builder.append(QueryBuilder.common(param, tag, key)).append(" ").append("'").append(param.getParam().get(key)).append("'");
                    }
                    continue block7;
                }
            }
        }
        return builder.toString();
    }

    static String common(Param param, String alias, String key) {
        StringBuilder builder = new StringBuilder();
        return builder.append(" ").append(param.getRelation().getRelation()).append(" ").append(alias).append(QueryBuilder.fieldToColumn(key)).append(" ").append(param.getSign().getSign()).toString();
    }

    private static String fieldToColumn(String field) {
        return EntityProcessor.fieldToColumn(field);
    }

    public static String buildGroup(String sql, List<String> groups) {
        StringBuilder builder = new StringBuilder(sql);
        if (StringUtils.hasText((String)sql) && (groups = ((List)Optional.ofNullable(groups).orElse(new ArrayList())).stream().filter(group -> StringUtils.hasText((String)group)).collect(Collectors.toList())).size() > 0) {
            builder.append(" GROUP BY ");
            groups.forEach(group -> builder.append((String)group).append(","));
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public static String buildPage(int pageNum, int pageSize) {
        pageSize = 0 >= pageSize ? 10 : pageSize;
        pageNum = 0 >= pageNum ? 1 : pageNum;
        return " LIMIT " + (pageNum - 1) * pageSize + "," + pageSize;
    }

    static String buildSort(Map<String, String> sorter, String tag) {
        StringBuilder builder = new StringBuilder();
        if ((sorter = (Map)Optional.ofNullable(sorter).orElse(new HashMap(0))).isEmpty()) {
            return builder.toString();
        }
        builder.append(" ORDER BY ");
        for (String column : sorter.keySet()) {
            if (((String)sorter.get(column)).equals("0")) {
                builder.append(" ").append(tag).append(".").append(QueryBuilder.fieldToColumn(column)).append(" ASC, ");
                continue;
            }
            builder.append(" ").append(tag).append(".").append(QueryBuilder.fieldToColumn(column)).append(" DESC, ");
        }
        builder.delete(builder.length() - 1, builder.length());
        return builder.toString();
    }

    static enum LikeMode {
        FULL,
        LEFT,
        RIGHT;

    }
}

