/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.builder;

import com.hecloud.runtime.common.query.Page;
import com.hecloud.runtime.common.query.Param;
import com.hecloud.runtime.common.query.Sign;
import com.hecloud.runtime.database.builder.InBuilder;
import com.hecloud.runtime.database.builder.QueryBuilder;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SelectBuilder {
    private static final Logger log = LoggerFactory.getLogger(SelectBuilder.class);
    private static EntityProcessor processor = new EntityProcessor();
    private StringBuilder builder;

    public SelectBuilder select(String ... fields) {
        this.builder = new StringBuilder("SELECT ");
        this.builder.append(this.buildFields(fields));
        return this;
    }

    public SelectBuilder from(Class ... classes) {
        Optional.ofNullable(classes).ifPresent(data -> this.builder.append(" FROM ").append(this.buildTables(classes)).append(" "));
        return this;
    }

    public SelectBuilder from(Class clazz, String alias) {
        Optional.ofNullable(clazz).ifPresent(data -> {
            this.builder.append(" FROM ").append(this.buildTables(clazz)).append(" ");
            Optional.ofNullable(alias).ifPresent(aliasData -> this.builder.append((String)aliasData).append(" "));
        });
        return this;
    }

    public SelectBuilder leftJoin(Class clazz, String alias) {
        Optional.ofNullable(clazz).ifPresent(data -> {
            this.builder.append(" LEFT JOIN ").append(processor.loadTableName((Class<?>)data)).append(" ");
            Optional.ofNullable(alias).ifPresent(aliasData -> this.builder.append((String)aliasData).append(" "));
        });
        return this;
    }

    public SelectBuilder on(String condition) {
        Optional.ofNullable(condition).ifPresent(data -> this.builder.append(" ON ").append((String)data));
        return this;
    }

    public SelectBuilder where(String condition) {
        Optional.ofNullable(condition).ifPresent(data -> this.builder.append(" WHERE ").append(condition));
        return this;
    }

    public SelectBuilder where(String column, Object data) {
        Optional.ofNullable(column).ifPresent(f -> Optional.ofNullable(data).ifPresent(d -> this.builder.append(" WHERE ").append((String)f).append(" ").append(Sign.EQ.getSign()).append(d.toString())));
        return this;
    }

    public SelectBuilder where(String column, Sign sign, Object data) {
        Optional.ofNullable(column).ifPresent(f -> Optional.ofNullable(sign).ifPresent(s -> Optional.ofNullable(data).ifPresent(d -> this.builder.append(" WHERE ").append(column).append(" ").append(sign.getSign()).append(data.toString()))));
        return this;
    }

    public SelectBuilder whereIn(String column, Collection conditions) {
        if (this.builder.toString().trim().endsWith(",")) {
            this.builder.deleteCharAt(this.builder.length() - 1);
        }
        Optional.ofNullable(column).ifPresent(f -> Optional.ofNullable(conditions).ifPresent(collection -> this.builder.append(" WHERE ").append(column).append(" IN ").append(InBuilder.build(conditions))));
        return this;
    }

    public SelectBuilder and(String condition) {
        Optional.ofNullable(condition).ifPresent(data -> this.builder.append(" AND ").append(condition));
        return this;
    }

    public SelectBuilder andIn(String column, Collection conditions) {
        Optional.ofNullable(column).ifPresent(f -> Optional.of(conditions).ifPresent(c -> this.builder.append(" AND ").append(column).append(" IN ").append(InBuilder.build(conditions))));
        return this;
    }

    public SelectBuilder or(String condition) {
        Optional.ofNullable(condition).ifPresent(c -> this.builder.append(" OR ").append(condition));
        return this;
    }

    public SelectBuilder orIn(String column, Collection conditions) {
        Optional.ofNullable(column).ifPresent(f -> Optional.of(conditions).ifPresent(c -> this.builder.append(" OR ").append(column).append(" IN ").append(InBuilder.build(conditions))));
        return this;
    }

    public SelectBuilder page(Page page) {
        this.builder.append(QueryBuilder.buildCondition(page.getParams(), ""));
        this.sort(page.getSorter());
        this.builder.append(QueryBuilder.buildPage(page.getPage(), page.getRows()));
        return this;
    }

    public SelectBuilder param(List<Param> params) {
        Optional.ofNullable(params).ifPresent(data -> this.builder.append(QueryBuilder.buildCondition(params, "")));
        return this;
    }

    public SelectBuilder sort(Map<String, String> sorter) {
        Optional.ofNullable(sorter).ifPresent(data -> {
            if (sorter.size() > 0) {
                this.builder.append(" ORDER BY ").append(" ");
                for (String column : sorter.keySet()) {
                    this.builder.append(EntityProcessor.fieldToColumn(column)).append(" ");
                    if (((String)sorter.get(column)).equals("0")) {
                        this.builder.append(" ASC, ").append(",");
                        continue;
                    }
                    this.builder.append(" DESC, ").append(",");
                }
                this.builder.delete(this.builder.length() - 1, this.builder.length());
            }
        });
        return this;
    }

    public SelectBuilder sort(Map<String, String> sorter, String alias) {
        Optional.ofNullable(sorter).ifPresent(data -> {
            if (sorter.size() > 0) {
                this.builder.append(" ORDER BY ").append(" ");
                for (String column : sorter.keySet()) {
                    if (StringUtils.hasText((String)alias)) {
                        this.builder.append(alias).append(".");
                    }
                    this.builder.append(EntityProcessor.fieldToColumn(column)).append(" ");
                    if (((String)sorter.get(column)).equals("0")) {
                        this.builder.append(" ASC, ").append(",");
                        continue;
                    }
                    this.builder.append(" DESC, ").append(",");
                }
                this.builder.delete(this.builder.length() - 1, this.builder.length());
            }
        });
        return this;
    }

    public String sql() {
        return this.builder.toString();
    }

    private String buildFields(String ... fields) {
        StringBuilder buffer = new StringBuilder();
        Arrays.asList(fields).forEach(field -> buffer.append((String)field).append(","));
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    private String buildTables(Class ... classes) {
        StringBuilder builder = new StringBuilder();
        Arrays.asList(classes).forEach(clazz -> builder.append(processor.loadTableName((Class<?>)clazz)).append(","));
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static SelectBuilderBuilder builder() {
        return new SelectBuilderBuilder();
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectBuilder)) {
            return false;
        }
        SelectBuilder other = (SelectBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringBuilder this$builder = this.getBuilder();
        StringBuilder other$builder = other.getBuilder();
        return !(this$builder == null ? other$builder != null : !this$builder.equals(other$builder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelectBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringBuilder $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
        return result;
    }

    public String toString() {
        return "SelectBuilder(builder=" + this.getBuilder() + ")";
    }

    private SelectBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    public static class SelectBuilderBuilder {
        private StringBuilder builder;

        SelectBuilderBuilder() {
        }

        public SelectBuilderBuilder builder(StringBuilder builder) {
            this.builder = builder;
            return this;
        }

        public SelectBuilder build() {
            return new SelectBuilder(this.builder);
        }

        public String toString() {
            return "SelectBuilder.SelectBuilderBuilder(builder=" + this.builder + ")";
        }
    }
}

