/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.cache;

import com.hecloud.runtime.database.emuns.ColumnField;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EntityCache
extends LinkedHashMap<String, List<ColumnField>> {
    private static final long serialVersionUID = 1L;
    private int capacity = 16;

    public EntityCache(int capacity) {
        super(16, 0.75f, true);
        if (capacity > 0) {
            this.capacity = capacity;
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, List<ColumnField>> eldest) {
        return super.size() > this.capacity;
    }

    public synchronized void putCache(String key, List<ColumnField> value) {
        this.put(key, value);
    }

    public synchronized List<ColumnField> getCache(String key) {
        List value = (List)this.get(key);
        Optional.ofNullable(value).ifPresent(data -> this.put(key, data));
        return value;
    }
}

