/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.core.intf.impl;

import com.hecloud.runtime.common.collections.Maps;
import com.hecloud.runtime.common.exception.DatabaseException;
import com.hecloud.runtime.common.query.Page;
import com.hecloud.runtime.common.query.Sign;
import com.hecloud.runtime.database.builder.QueryBuilder;
import com.hecloud.runtime.database.builder.SQLBuilder;
import com.hecloud.runtime.database.builder.SelectBuilder;
import com.hecloud.runtime.database.builder.UpdateBuilder;
import com.hecloud.runtime.database.convertor.BeanConverter;
import com.hecloud.runtime.database.convertor.EntityProcessor;
import com.hecloud.runtime.database.core.intf.GenericDao;
import com.hecloud.runtime.database.engine.DataEngine;
import com.hecloud.runtime.database.engine.JdbcEngine;
import com.hecloud.runtime.database.entity.GenericEntity;
import com.hecloud.runtime.database.utils.Condition;
import com.hecloud.runtime.database.utils.Conditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class JdbcGenericDao<T extends GenericEntity, Pk extends Serializable>
implements GenericDao<T, Pk>,
InitializingBean {
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate npJdbcTemplate;
    private SQLBuilder builder;
    private EntityProcessor processor;
    private BeanConverter converter;
    private DataEngine<T> engine;

    @Autowired
    public JdbcGenericDao(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate npJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.npJdbcTemplate = npJdbcTemplate;
    }

    @Override
    public void save(T entity) throws DatabaseException {
        this.engine.save(entity);
    }

    @Override
    public boolean batchSave(List<T> entityList, Integer batchSize) throws DatabaseException {
        return this.engine.batchInsert(entityList, batchSize);
    }

    @Override
    public boolean update(T entity) throws DatabaseException {
        return this.engine.update(entity);
    }

    @Override
    public boolean update(T entity, String[] fields) throws DatabaseException {
        return this.engine.update(entity);
    }

    @Override
    public boolean batchUpdate(List<T> entityList, Integer batchSize) throws DatabaseException {
        return this.engine.batchUpdate(entityList, batchSize);
    }

    @Override
    public boolean batchUpdate(List<T> entityList, String[] fields, Integer batchSize) throws DatabaseException {
        return this.engine.batchUpdate(entityList, fields, batchSize);
    }

    @Override
    public boolean delete(Class<T> clazz, Pk id) throws DatabaseException {
        return this.engine.delete(clazz, (Serializable)id);
    }

    @Override
    public boolean remove(Class<T> clazz, Pk id) throws DatabaseException {
        String delete = UpdateBuilder.builder().build().update(clazz).set("is_deleted = true").set("gmt_modify = :DATE").where("id = :ID").sql();
        Map params = Maps.single((String)"id", id);
        params.put("gmtModify", new Date());
        return this.engine.execute(delete, params) > 0;
    }

    @Override
    public void execute(String sql) throws DatabaseException {
        this.engine.execute(sql);
    }

    @Override
    public int execute(String sql, Map<String, Object> params) {
        return this.engine.execute(sql, params);
    }

    @Override
    public T queryForEntity(Class<T> clazz, Condition condition, Map<String, Object> params) throws DatabaseException {
        String select = SelectBuilder.builder().build().select("*").from(clazz).where("1=1").and(condition.build()).sql();
        List<Map<String, Object>> list = this.engine.list(select, params);
        Assert.notEmpty(list, (String)"no data found!");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"more than 1 record!");
        Map<String, Object> map = list.get(0);
        try {
            return (T)((GenericEntity)this.converter.mapToBean(map, clazz));
        }
        catch (Throwable e) {
            throw new DatabaseException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public T get(Class<T> clazz, Pk id) throws DatabaseException {
        String pkColumn = this.processor.loadSinglePk(clazz);
        Condition condition = Conditions.simple(pkColumn, Sign.EQ);
        Map param = Maps.single((String)pkColumn, id);
        return this.queryForEntity(clazz, condition, param);
    }

    @Override
    public T load(Class<T> clazz, Pk id) throws DatabaseException {
        return (T)((GenericEntity)this.engine.load(clazz, (Serializable)id));
    }

    @Override
    public List<Map<String, Object>> list(String sql) throws DatabaseException {
        return this.engine.list(sql, null);
    }

    @Override
    public List<T> page(Class<T> clazz, Page page) throws DatabaseException {
        String sql = QueryBuilder.build(this.builder.buildSelect(clazz), page, "");
        return this.list(clazz, sql);
    }

    @Override
    public List<T> list(Class<T> clazz, String sql) throws DatabaseException {
        return this.toList(this.engine.list(sql, null), clazz);
    }

    @Override
    public List<Map<String, Object>> list(String sql, Map<String, Object> params) throws DatabaseException {
        return this.engine.list(sql, params);
    }

    @Override
    public List<T> list(Class<T> clazz, String sql, Map<String, Object> params) throws DatabaseException {
        return this.toList(this.list(sql, params), clazz);
    }

    private List<T> toList(List<Map<String, Object>> metaList, Class<T> clazz) {
        ArrayList<GenericEntity> list = new ArrayList<GenericEntity>();
        try {
            for (Map<String, Object> meta : metaList) {
                list.add((GenericEntity)this.converter.mapToBean(meta, clazz));
            }
            return list;
        }
        catch (Throwable e) {
            throw new DatabaseException("entity map exception", e);
        }
    }

    @Override
    public Long countQuery(String sql, Map<String, Object> param) throws DatabaseException {
        return this.engine.count(sql, param);
    }

    @Override
    public Long count(Class<T> clazz, Conditions conditions, Map<String, Object> params) throws DatabaseException {
        return this.engine.count(clazz, conditions, params);
    }

    @Override
    public List<T> queryForList(Class<T> clazz, Conditions conditions, Map<String, Object> paramMap) throws DatabaseException {
        return this.toList(this.engine.list(clazz, conditions, paramMap), clazz);
    }

    public void afterPropertiesSet() throws DatabaseException {
        this.builder = new SQLBuilder();
        this.processor = new EntityProcessor();
        this.converter = new BeanConverter(this.processor);
        this.engine = new JdbcEngine(this.jdbcTemplate, this.npJdbcTemplate, this.builder, this.processor, this.converter);
    }
}

