/*
 * Decompiled with CFR 0.152.
 */
package com.hecloud.runtime.database.datasource;

import com.hecloud.runtime.database.datasource.DataSourceSwitch;
import com.hecloud.runtime.database.datasource.DynamicDataSource;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class DataSourceAspect {
    private static Logger logger = LoggerFactory.getLogger(DataSourceAspect.class);

    @Pointcut(value="@annotation(DataSourceSwitch)")
    private void changeDS() {
    }

    @Around(value="changeDS() ", argNames="pjp")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        DataSourceSwitch annotation = method.getAnnotation(DataSourceSwitch.class);
        boolean selectedDataSource = false;
        try {
            if (null == annotation) {
                Object object = pjp.proceed();
                return object;
            }
            selectedDataSource = true;
            if (annotation.slave()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method {} use slave datasource", (Object)method.getName());
                }
                DynamicDataSource.useSlave();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method {} use master datasource", (Object)method.getName());
                }
                DynamicDataSource.useMaster();
            }
            Object object = pjp.proceed();
            return object;
        }
        catch (Throwable e) {
            logger.error("DataSource switch exception:", e);
            throw e;
        }
        finally {
            if (selectedDataSource) {
                DynamicDataSource.reset();
            }
        }
    }
}

