/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.clerezza;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;

public class ClerezzaRDFParser
implements RDFParser {
    private static String RDF_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    private long count = 0L;

    public RDFDataset parse(Object input) throws JsonLdError {
        this.count = 0L;
        HashMap<BlankNode, String> blankNodeMap = new HashMap<BlankNode, String>(1024);
        RDFDataset result = new RDFDataset();
        if (input instanceof Graph) {
            for (Triple t : (Graph)input) {
                this.handleStatement(result, t, blankNodeMap);
            }
        }
        blankNodeMap.clear();
        return result;
    }

    private void handleStatement(RDFDataset result, Triple t, Map<BlankNode, String> blankNodeMap) {
        String subject = this.getResourceValue(t.getSubject(), blankNodeMap);
        String predicate = this.getResourceValue((BlankNodeOrIRI)t.getPredicate(), blankNodeMap);
        RDFTerm object = t.getObject();
        if (object instanceof Literal) {
            String datatype;
            String language;
            Literal literalObject = (Literal)object;
            String value = literalObject.getLexicalForm();
            if (literalObject.getLanguage() != null) {
                language = literalObject.getLanguage().toString();
                datatype = RDF_LANG_STRING;
            } else {
                datatype = this.getResourceValue((BlankNodeOrIRI)literalObject.getDataType(), blankNodeMap);
                language = null;
            }
            result.addTriple(subject, predicate, value, datatype, language);
            ++this.count;
        } else {
            result.addTriple(subject, predicate, this.getResourceValue((BlankNodeOrIRI)object, blankNodeMap));
            ++this.count;
        }
    }

    public long getCount() {
        return this.count;
    }

    private String getResourceValue(BlankNodeOrIRI nl, Map<BlankNode, String> BlankNodeMap) {
        if (nl == null) {
            return null;
        }
        if (nl instanceof IRI) {
            return ((IRI)nl).getUnicodeString();
        }
        if (nl instanceof BlankNode) {
            String BlankNodeId = BlankNodeMap.get(nl);
            if (BlankNodeId == null) {
                BlankNodeId = Integer.toString(BlankNodeMap.size());
                BlankNodeMap.put((BlankNode)nl, BlankNodeId);
            }
            return "_:b" + BlankNodeId;
        }
        throw new IllegalStateException("Unknwon BlankNodeOrIRI type " + nl.getClass().getName() + "!");
    }
}

