/*
 * Decompiled with CFR 0.152.
 */
package com.github.lowzj.retry;

import com.github.lowzj.retry.AttemptTimeLimiter;
import com.github.lowzj.retry.Preconditions;
import com.github.lowzj.retry.RetryException;
import com.github.lowzj.retry.RetryListener;
import com.github.lowzj.retry.StopStrategy;
import com.github.lowzj.retry.WaitStrategy;
import com.github.lowzj.retry.attempt.Attempt;
import com.github.lowzj.retry.attempt.ExceptionAttempt;
import com.github.lowzj.retry.attempt.ResultAttempt;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class AsyncRetryer<V> {
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;
    private final AttemptTimeLimiter<V> attemptTimeLimiter;
    private final Predicate<Attempt<V>> rejectionPredicate;
    private final Collection<RetryListener<V>> listeners;
    private final ScheduledExecutorService executor;

    AsyncRetryer(AttemptTimeLimiter<V> attemptTimeLimiter, StopStrategy stopStrategy, WaitStrategy waitStrategy, Predicate<Attempt<V>> rejectionPredicate, Collection<RetryListener<V>> listeners, ScheduledExecutorService executor) {
        Preconditions.assertNotNull(attemptTimeLimiter, "timeLimiter may not be null");
        Preconditions.assertNotNull(stopStrategy, "stopStrategy may not be null");
        Preconditions.assertNotNull(waitStrategy, "waitStrategy may not be null");
        Preconditions.assertNotNull(rejectionPredicate, "rejectionPredicate may not be null");
        Preconditions.assertNotNull(listeners, "listeners may not be null");
        Preconditions.assertNotNull(executor, "executor may not be null");
        this.attemptTimeLimiter = attemptTimeLimiter;
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
        this.rejectionPredicate = rejectionPredicate;
        this.listeners = listeners;
        this.executor = executor;
    }

    public CompletableFuture<V> call(Callable<V> callable) {
        CompletableFuture resultFuture = new CompletableFuture();
        this.executor.execute(this.createRunner(callable, System.nanoTime(), 1, resultFuture));
        return resultFuture;
    }

    private Runnable createRunner(Callable<V> callable, long startTime, int attemptNumber, CompletableFuture<V> resultFuture) {
        return () -> {
            Attempt<Object> attempt;
            Object result;
            try {
                result = this.attemptTimeLimiter.call(callable);
                attempt = new ResultAttempt<V>(result, attemptNumber, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            catch (Throwable t) {
                attempt = new ExceptionAttempt(t, attemptNumber, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            for (RetryListener<Object> retryListener : this.listeners) {
                retryListener.onRetry(attempt);
            }
            if (!this.rejectionPredicate.test(attempt)) {
                try {
                    result = attempt.get();
                    resultFuture.complete(result);
                }
                catch (ExecutionException e) {
                    resultFuture.completeExceptionally(e);
                }
            }
            if (resultFuture.isDone()) {
                return;
            }
            if (this.stopStrategy.shouldStop(attempt)) {
                resultFuture.completeExceptionally(new RetryException(attemptNumber, attempt));
            } else {
                this.executor.schedule(this.createRunner(callable, startTime, attemptNumber + 1, resultFuture), TimeUnit.MILLISECONDS.toMicros(this.waitStrategy.computeSleepTime(attempt)), TimeUnit.MICROSECONDS);
            }
        };
    }
}

