/*
 * Decompiled with CFR 0.152.
 */
package com.github.lowzj.retry;

import com.github.lowzj.retry.AttemptTimeLimiter;
import com.github.lowzj.retry.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AttemptTimeLimiters {
    private AttemptTimeLimiters() {
    }

    public static <V> AttemptTimeLimiter<V> noTimeLimit() {
        return new NoAttemptTimeLimit();
    }

    public static <V> AttemptTimeLimiter<V> fixedTimeLimit(long duration, TimeUnit timeUnit, ExecutorService executorService) {
        return new FixedAttemptTimeLimit(duration, timeUnit, executorService);
    }

    private static final class FixedAttemptTimeLimit<V>
    implements AttemptTimeLimiter<V> {
        private final long duration;
        private final TimeUnit timeUnit;
        private final ExecutorService executorService;

        private FixedAttemptTimeLimit(long duration, TimeUnit timeUnit, ExecutorService executorService) {
            Preconditions.assertNotNull(timeUnit, "timeUnit may not null");
            Preconditions.assertNotNull(executorService, "executorService may not null");
            this.duration = duration;
            this.timeUnit = timeUnit;
            this.executorService = executorService;
        }

        @Override
        public V call(Callable<V> callable) throws Exception {
            Preconditions.assertNotNull(callable);
            Preconditions.assertNotNull(this.timeUnit);
            Preconditions.checkArgument(this.duration > 0L, "timeout must be positive: " + this.duration, new Object[0]);
            Future<V> future = this.executorService.submit(callable);
            try {
                return future.get(this.duration, this.timeUnit);
            }
            catch (InterruptedException | TimeoutException e) {
                future.cancel(true);
                throw e;
            }
        }
    }

    private static final class NoAttemptTimeLimit<V>
    implements AttemptTimeLimiter<V> {
        private NoAttemptTimeLimit() {
        }

        @Override
        public V call(Callable<V> callable) throws Exception {
            return callable.call();
        }
    }
}

