/*
 * Decompiled with CFR 0.152.
 */
package com.github.lowzj.retry;

import com.github.lowzj.retry.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class ExecutorsUtil {
    private static Map<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();

    public static ScheduledExecutorService scheduledExecutorService(String poolName, int corePoolSize) {
        return (ScheduledExecutorService)ExecutorsUtil.getOrCreate(poolName, ScheduledExecutorService.class, () -> new ScheduledThreadPoolExecutor(corePoolSize, ExecutorsUtil.newThreadFactor(poolName)));
    }

    public static ExecutorService executorService(String poolName, int corePoolSize, int maximumPoolSize) {
        return ExecutorsUtil.getOrCreate(poolName, ExecutorService.class, () -> new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorsUtil.newThreadFactor(poolName)));
    }

    private static ExecutorService getOrCreate(String poolName, Class returnClass, Supplier<? extends ExecutorService> executorServiceSupplier) {
        Preconditions.assertNotNull(poolName, "poolName may not be null");
        String key = ExecutorsUtil.key(poolName, returnClass);
        ExecutorService executorService = executors.get(key);
        if (executorService != null) {
            return executorService;
        }
        return executors.computeIfAbsent(key, k -> (ExecutorService)executorServiceSupplier.get());
    }

    private static ThreadFactory newThreadFactor(String name) {
        return new NamedThreadFactory(name);
    }

    private static String key(String poolName, Class returnClass) {
        return poolName + "#" + returnClass.getSimpleName();
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String namePrefix) {
            Preconditions.assertNotNull(namePrefix, "namePrefix may not be null");
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

