/*
 * Decompiled with CFR 0.152.
 */
package com.github.lowzj.retry;

import com.github.lowzj.retry.AttemptTimeLimiter;
import com.github.lowzj.retry.BlockStrategy;
import com.github.lowzj.retry.Preconditions;
import com.github.lowzj.retry.RetryException;
import com.github.lowzj.retry.RetryListener;
import com.github.lowzj.retry.StopStrategy;
import com.github.lowzj.retry.WaitStrategy;
import com.github.lowzj.retry.attempt.Attempt;
import com.github.lowzj.retry.attempt.ExceptionAttempt;
import com.github.lowzj.retry.attempt.ResultAttempt;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class Retryer<V> {
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;
    private final BlockStrategy blockStrategy;
    private final AttemptTimeLimiter<V> attemptTimeLimiter;
    private final Predicate<Attempt<V>> rejectionPredicate;
    private final Collection<RetryListener<V>> listeners;

    Retryer(AttemptTimeLimiter<V> attemptTimeLimiter, StopStrategy stopStrategy, WaitStrategy waitStrategy, BlockStrategy blockStrategy, Predicate<Attempt<V>> rejectionPredicate, Collection<RetryListener<V>> listeners) {
        Preconditions.assertNotNull(attemptTimeLimiter, "timeLimiter may not be null");
        Preconditions.assertNotNull(stopStrategy, "stopStrategy may not be null");
        Preconditions.assertNotNull(waitStrategy, "waitStrategy may not be null");
        Preconditions.assertNotNull(blockStrategy, "blockStrategy may not be null");
        Preconditions.assertNotNull(rejectionPredicate, "rejectionPredicate may not be null");
        Preconditions.assertNotNull(listeners, "listeners may not null");
        this.attemptTimeLimiter = attemptTimeLimiter;
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
        this.blockStrategy = blockStrategy;
        this.rejectionPredicate = rejectionPredicate;
        this.listeners = listeners;
    }

    public V call(Callable<V> callable) throws ExecutionException, RetryException {
        long startTime = System.nanoTime();
        int attemptNumber = 1;
        while (true) {
            Attempt<Object> attempt;
            try {
                V result = this.attemptTimeLimiter.call(callable);
                attempt = new ResultAttempt<V>(result, attemptNumber, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            catch (Throwable t) {
                attempt = new ExceptionAttempt(t, attemptNumber, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            for (RetryListener<Object> retryListener : this.listeners) {
                retryListener.onRetry(attempt);
            }
            if (!this.rejectionPredicate.test(attempt)) {
                return (V)attempt.get();
            }
            if (this.stopStrategy.shouldStop(attempt)) {
                throw new RetryException(attemptNumber, attempt);
            }
            long sleepTime = this.waitStrategy.computeSleepTime(attempt);
            try {
                this.blockStrategy.block(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RetryException(attemptNumber, attempt);
            }
            ++attemptNumber;
        }
    }

    public RetryerCallable<V> wrap(Callable<V> callable) {
        return new RetryerCallable(this, callable);
    }

    public static class RetryerCallable<X>
    implements Callable<X> {
        private Retryer<X> retryer;
        private Callable<X> callable;

        private RetryerCallable(Retryer<X> retryer, Callable<X> callable) {
            this.retryer = retryer;
            this.callable = callable;
        }

        @Override
        public X call() throws ExecutionException, RetryException {
            return this.retryer.call(this.callable);
        }
    }
}

