/*
 * Decompiled with CFR 0.152.
 */
package com.github.lowzj.retry;

import com.github.lowzj.retry.AsyncRetryer;
import com.github.lowzj.retry.AttemptTimeLimiter;
import com.github.lowzj.retry.AttemptTimeLimiters;
import com.github.lowzj.retry.BlockStrategies;
import com.github.lowzj.retry.BlockStrategy;
import com.github.lowzj.retry.ExecutorsUtil;
import com.github.lowzj.retry.Preconditions;
import com.github.lowzj.retry.RetryListener;
import com.github.lowzj.retry.Retryer;
import com.github.lowzj.retry.StopStrategies;
import com.github.lowzj.retry.StopStrategy;
import com.github.lowzj.retry.WaitStrategies;
import com.github.lowzj.retry.WaitStrategy;
import com.github.lowzj.retry.attempt.Attempt;
import com.github.lowzj.retry.predicate.ExceptionClassPredicate;
import com.github.lowzj.retry.predicate.ExceptionPredicate;
import com.github.lowzj.retry.predicate.ResultPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;

public class RetryerBuilder<V> {
    private AttemptTimeLimiter<V> attemptTimeLimiter;
    private StopStrategy stopStrategy;
    private WaitStrategy waitStrategy;
    private BlockStrategy blockStrategy;
    private Predicate<Attempt<V>> rejectionPredicate = vAttempt -> false;
    private List<RetryListener<V>> listeners = new ArrayList<RetryListener<V>>();
    private ScheduledExecutorService executor;

    private RetryerBuilder() {
    }

    public static <V> RetryerBuilder<V> newBuilder() {
        return new RetryerBuilder<V>();
    }

    public RetryerBuilder<V> withRetryListener(RetryListener<V> listener) {
        Preconditions.assertNotNull(listener, "listener may not be null");
        this.listeners.add(listener);
        return this;
    }

    public RetryerBuilder<V> withWaitStrategy(WaitStrategy waitStrategy) throws IllegalStateException {
        Preconditions.assertNotNull(waitStrategy, "waitStrategy may not be null");
        Preconditions.checkState(this.waitStrategy == null, "a wait strategy has already been set %s", this.waitStrategy);
        this.waitStrategy = waitStrategy;
        return this;
    }

    public RetryerBuilder<V> withStopStrategy(StopStrategy stopStrategy) throws IllegalStateException {
        Preconditions.assertNotNull(stopStrategy, "stopStrategy may not be null");
        Preconditions.checkState(this.stopStrategy == null, "a stop strategy has already been set %s", this.stopStrategy);
        this.stopStrategy = stopStrategy;
        return this;
    }

    public RetryerBuilder<V> withBlockStrategy(BlockStrategy blockStrategy) throws IllegalStateException {
        Preconditions.assertNotNull(blockStrategy, "blockStrategy may not be null");
        Preconditions.checkState(this.blockStrategy == null, "a block strategy has already been set %s", this.blockStrategy);
        this.blockStrategy = blockStrategy;
        return this;
    }

    public RetryerBuilder<V> withAttemptTimeLimiter(AttemptTimeLimiter<V> attemptTimeLimiter) {
        Preconditions.assertNotNull(attemptTimeLimiter);
        this.attemptTimeLimiter = attemptTimeLimiter;
        return this;
    }

    public RetryerBuilder<V> withExecutor(ScheduledExecutorService executor) {
        Preconditions.assertNotNull(executor);
        this.executor = executor;
        return this;
    }

    public RetryerBuilder<V> retryIfException() {
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionClassPredicate(Exception.class));
        return this;
    }

    public RetryerBuilder<V> retryIfRuntimeException() {
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionClassPredicate(RuntimeException.class));
        return this;
    }

    public RetryerBuilder<V> retryIfExceptionOfType(Class<? extends Throwable> exceptionClass) {
        Preconditions.assertNotNull(exceptionClass, "exceptionClass may not be null");
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionClassPredicate(exceptionClass));
        return this;
    }

    public RetryerBuilder<V> retryIfException(Predicate<Throwable> exceptionPredicate) {
        Preconditions.assertNotNull(exceptionPredicate, "exceptionPredicate may not be null");
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionPredicate(exceptionPredicate));
        return this;
    }

    public RetryerBuilder<V> retryIfResult(Predicate<V> resultPredicate) {
        Preconditions.assertNotNull(resultPredicate, "resultPredicate may not be null");
        this.rejectionPredicate = this.rejectionPredicate.or(new ResultPredicate<V>(resultPredicate));
        return this;
    }

    public Retryer<V> build() {
        AttemptTimeLimiter theAttemptTimeLimiter = this.attemptTimeLimiter == null ? AttemptTimeLimiters.noTimeLimit() : this.attemptTimeLimiter;
        StopStrategy theStopStrategy = this.stopStrategy == null ? StopStrategies.neverStop() : this.stopStrategy;
        WaitStrategy theWaitStrategy = this.waitStrategy == null ? WaitStrategies.noWait() : this.waitStrategy;
        BlockStrategy theBlockStrategy = this.blockStrategy == null ? BlockStrategies.threadSleepStrategy() : this.blockStrategy;
        return new Retryer(theAttemptTimeLimiter, theStopStrategy, theWaitStrategy, theBlockStrategy, this.rejectionPredicate, this.listeners);
    }

    public AsyncRetryer<V> buildAsyncRetryer() {
        AttemptTimeLimiter theAttemptTimeLimiter = this.attemptTimeLimiter == null ? AttemptTimeLimiters.noTimeLimit() : this.attemptTimeLimiter;
        StopStrategy theStopStrategy = this.stopStrategy == null ? StopStrategies.neverStop() : this.stopStrategy;
        WaitStrategy theWaitStrategy = this.waitStrategy == null ? WaitStrategies.noWait() : this.waitStrategy;
        ScheduledExecutorService theExecutor = this.executor == null ? ExecutorsUtil.scheduledExecutorService("default-async-retry", 5) : this.executor;
        return new AsyncRetryer(theAttemptTimeLimiter, theStopStrategy, theWaitStrategy, this.rejectionPredicate, this.listeners, theExecutor);
    }
}

